/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.comparison;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.xemor.superheroes.configurationdata.comparison.EnchantComparisonData;
import me.xemor.superheroes.configurationdata.comparison.LoreData;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public record ItemMetaComparisonData(Pattern displayName, LoreData lore, EnchantComparisonData enchantComparisonData) {
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();

    @JsonCreator
    public ItemMetaComparisonData(@JsonProperty(value="displayName") String displayName, @JsonProperty(value="lore") LoreData lore, @JsonProperty(value="enchants") EnchantComparisonData enchantComparisonData) {
        this(Pattern.compile(legacySerializer.serialize((Component)MiniMessage.miniMessage().deserialize(displayName == null ? ".+" : displayName))), lore == null ? new LoreData(List.of()) : lore, enchantComparisonData);
    }

    public boolean matches(ItemMeta meta) {
        boolean matching;
        if (meta == null) {
            return false;
        }
        boolean bl = matching = this.matchDisplayName(meta.getDisplayName()) && this.lore.matches(meta.getLore());
        if (this.enchantComparisonData != null) {
            Map enchantMap;
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
                enchantMap = enchantmentStorageMeta.getStoredEnchants();
            } else {
                enchantMap = meta.getEnchants();
            }
            matching &= this.enchantComparisonData.matches(enchantMap);
        }
        return matching;
    }

    public boolean matchDisplayName(String name) {
        if (name == null) {
            name = "";
        }
        return this.displayName.matcher(name).matches();
    }
}

