/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.comparison;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@JsonDeserialize(using=LoreDataDeserializer.class)
public class LoreData {
    private List<Pattern> patternLore;
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();

    public LoreData(List<String> lore) {
        this.patternLore = lore.stream().map(string -> legacySerializer.serialize((Component)MiniMessage.miniMessage().deserialize(string))).map(Pattern::compile).collect(Collectors.toList());
    }

    public boolean matches(List<String> lore) {
        if (lore == null) {
            lore = Collections.emptyList();
        }
        if (this.patternLore.size() > 0 && this.patternLore.size() < lore.size()) {
            return false;
        }
        for (int i = 0; i < this.patternLore.size(); ++i) {
            String line = i >= lore.size() ? "" : lore.get(i);
            Pattern pattern = this.patternLore.get(i);
            if (pattern.matcher(line).matches()) continue;
            return false;
        }
        return true;
    }

    public static class LoreDataDeserializer
    extends JsonDeserializer<LoreData> {
        public LoreData deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            ArrayList<String> lore = new ArrayList<String>();
            JsonNode node = (JsonNode)jsonParser.readValueAsTree();
            for (JsonNode element : node) {
                String value = (String)jsonParser.getCodec().treeToValue((TreeNode)element, String.class);
                lore.add(value);
            }
            return new LoreData(lore);
        }
    }
}

