/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.entity;

import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.configurationdata.entity.AbstractArrowComponent;
import me.xemor.superheroes.configurationdata.entity.ArrowComponent;
import me.xemor.superheroes.configurationdata.entity.AxolotlComponent;
import me.xemor.superheroes.configurationdata.entity.CreeperComponent;
import me.xemor.superheroes.configurationdata.entity.DroppedItemComponent;
import me.xemor.superheroes.configurationdata.entity.ExperienceOrbComponent;
import me.xemor.superheroes.configurationdata.entity.FallingBlockComponent;
import me.xemor.superheroes.configurationdata.entity.HorseComponent;
import me.xemor.superheroes.configurationdata.entity.LivingEntityComponent;
import me.xemor.superheroes.configurationdata.entity.LlamaComponent;
import me.xemor.superheroes.configurationdata.entity.PotionEntityComponent;
import me.xemor.superheroes.configurationdata.entity.PrimedTntComponent;
import me.xemor.superheroes.configurationdata.entity.RabbitComponent;
import me.xemor.superheroes.configurationdata.entity.SpectralArrowComponent;
import me.xemor.superheroes.configurationdata.entity.WitherSkullComponent;
import me.xemor.superheroes.configurationdata.entity.WolfComponent;
import me.xemor.superheroes.configurationdata.entity.components.AgeableComponent;
import me.xemor.superheroes.configurationdata.entity.components.ColorableComponent;
import me.xemor.superheroes.configurationdata.entity.components.EntityComponent;
import me.xemor.superheroes.configurationdata.entity.components.ExplosiveComponent;
import me.xemor.superheroes.configurationdata.entity.components.SizeComponent;
import me.xemor.superheroes.configurationdata.entity.components.ThrowableProjectileComponent;
import me.xemor.superheroes.configurationdata.entity.components.ZombifiableComponent;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.material.Colorable;

public class EntityComponentRegistry {
    private static final List<EntityClassToComponentPair> entityTypeToDataClass = new ArrayList<EntityClassToComponentPair>();

    public static void registerEntityData(Class inheritsFrom, Class<? extends EntityComponent> entityComponentDataClass) {
        entityTypeToDataClass.add(new EntityClassToComponentPair(inheritsFrom, entityComponentDataClass));
    }

    public static List<? extends Class<? extends EntityComponent>> getEntityComponentDataClasses(Class<? extends Entity> inheritsFrom) {
        return entityTypeToDataClass.stream().filter(pair -> pair.clazz.isAssignableFrom(inheritsFrom)).map(pair -> pair.componentClazz).toList();
    }

    static {
        EntityComponentRegistry.registerEntityData(Arrow.class, ArrowComponent.class);
        EntityComponentRegistry.registerEntityData(Axolotl.class, AxolotlComponent.class);
        EntityComponentRegistry.registerEntityData(Creeper.class, CreeperComponent.class);
        EntityComponentRegistry.registerEntityData(Item.class, DroppedItemComponent.class);
        EntityComponentRegistry.registerEntityData(ExperienceOrb.class, ExperienceOrbComponent.class);
        EntityComponentRegistry.registerEntityData(FallingBlock.class, FallingBlockComponent.class);
        EntityComponentRegistry.registerEntityData(AbstractHorse.class, HorseComponent.class);
        EntityComponentRegistry.registerEntityData(Llama.class, LlamaComponent.class);
        EntityComponentRegistry.registerEntityData(TNTPrimed.class, PrimedTntComponent.class);
        EntityComponentRegistry.registerEntityData(SpectralArrow.class, SpectralArrowComponent.class);
        EntityComponentRegistry.registerEntityData(ThrownPotion.class, PotionEntityComponent.class);
        EntityComponentRegistry.registerEntityData(Rabbit.class, RabbitComponent.class);
        EntityComponentRegistry.registerEntityData(Trident.class, AbstractArrowComponent.class);
        EntityComponentRegistry.registerEntityData(WitherSkull.class, WitherSkullComponent.class);
        EntityComponentRegistry.registerEntityData(Wolf.class, WolfComponent.class);
        EntityComponentRegistry.registerEntityData(Ageable.class, AgeableComponent.class);
        EntityComponentRegistry.registerEntityData(Colorable.class, ColorableComponent.class);
        EntityComponentRegistry.registerEntityData(Explosive.class, ExplosiveComponent.class);
        EntityComponentRegistry.registerEntityData(Slime.class, SizeComponent.class);
        EntityComponentRegistry.registerEntityData(Phantom.class, SizeComponent.class);
        EntityComponentRegistry.registerEntityData(ThrowableProjectile.class, ThrowableProjectileComponent.class);
        EntityComponentRegistry.registerEntityData(PiglinAbstract.class, ZombifiableComponent.class);
        EntityComponentRegistry.registerEntityData(Hoglin.class, ZombifiableComponent.class);
        EntityComponentRegistry.registerEntityData(LivingEntity.class, LivingEntityComponent.class);
    }

    private record EntityClassToComponentPair(Class clazz, Class<? extends EntityComponent> componentClazz) {
    }
}

