/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.entity.EntityData;
import me.xemor.superheroes.configurationdata.entity.components.EntityComponent;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HorseComponent
implements EntityComponent {
    @JsonPropertyWithDefault
    private int tamingDifficulty = 1;
    @JsonPropertyWithDefault
    private double jumpStrength = 0.7;
    @JsonPropertyWithDefault
    private boolean hasChest = false;
    @JsonPropertyWithDefault
    private boolean tamed = false;
    @JsonPropertyWithDefault
    private ItemStack armor = null;
    @JsonPropertyWithDefault
    private boolean hasSaddle = false;
    @JsonPropertyWithDefault
    private Horse.Color color = Horse.Color.CHESTNUT;
    @JsonPropertyWithDefault
    private Horse.Style style = Horse.Style.NONE;

    @Override
    public void apply(Entity entity, EntityData builderSoFar) {
        AbstractHorse horse;
        if (entity instanceof AbstractHorse) {
            horse = (AbstractHorse)entity;
            horse.getInventory().setSaddle(this.hasSaddle ? new ItemStack(Material.SADDLE) : null);
            horse.setMaxDomestication(this.tamingDifficulty);
            horse.setJumpStrength(this.jumpStrength);
            horse.setTamed(this.tamed);
        }
        if (entity instanceof Horse) {
            horse = (Horse)entity;
            horse.getInventory().setArmor(this.armor);
            horse.setColor(this.color);
            horse.setStyle(this.style);
        }
        if (entity instanceof ChestedHorse) {
            ChestedHorse chestedHorse = (ChestedHorse)entity;
            chestedHorse.setCarryingChest(this.hasChest);
        }
    }
}

