/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import me.xemor.superheroes.configurationdata.EquipmentData;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.entity.EntityData;
import me.xemor.superheroes.configurationdata.entity.components.EntityComponent;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LivingEntityComponent
implements EntityComponent {
    @JsonPropertyWithDefault
    private boolean canEquip = false;
    @JsonPropertyWithDefault
    private EquipmentData equipment = null;

    @Override
    public void apply(Entity entity, EntityData builderSoFar) {
        LivingEntity livingEntity = (LivingEntity)entity;
        livingEntity.setRemoveWhenFarAway(builderSoFar.shouldDespawn());
        livingEntity.setCanPickupItems(this.canEquip);
        if (this.equipment != null) {
            this.equipment.applyEquipment(livingEntity);
        }
        for (Map.Entry<Attribute, Double> entry : builderSoFar.getAttributes().entrySet()) {
            livingEntity.getAttribute(entry.getKey()).setBaseValue(entry.getValue().doubleValue());
        }
        livingEntity.setHealth(livingEntity.getAttribute(Attribute.MAX_HEALTH).getValue());
    }

    public EquipmentData getEquipment() {
        return this.equipment;
    }
}

