/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.recipes;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.xemor.superheroes.configurationdata.CompulsoryJsonProperty;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class ShapedRecipeData {
    @CompulsoryJsonProperty
    private List<String> recipe = new ArrayList<String>();
    @CompulsoryJsonProperty
    private Map<Material, String> recipeKeys = new HashMap<Material, String>();
    @CompulsoryJsonProperty
    private ItemStack result;
    @CompulsoryJsonProperty
    @JsonAlias(value={"unique_key"})
    private String uniqueKey;
    @JsonIgnore
    private boolean hasRegisteredRecipe = false;

    public Recipe getRecipeAndLazyRegister() {
        ShapedRecipe shapedRecipe = new ShapedRecipe(new NamespacedKey((Plugin)ConfigurationData.getPlugin(), this.uniqueKey), this.result);
        shapedRecipe.shape(this.recipe.toArray(new String[0]));
        for (Map.Entry<Material, String> entry : this.recipeKeys.entrySet()) {
            shapedRecipe.setIngredient(entry.getValue().charAt(0), entry.getKey());
        }
        if (!this.hasRegisteredRecipe) {
            this.hasRegisteredRecipe = true;
            Bukkit.addRecipe((Recipe)shapedRecipe);
        }
        return shapedRecipe;
    }
}

