/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.recipes;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import me.xemor.superheroes.configurationdata.CompulsoryJsonProperty;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class ShapelessRecipeData {
    @CompulsoryJsonProperty
    private ItemStack result;
    @CompulsoryJsonProperty
    private Map<Material, Integer> ingredients = new HashMap<Material, Integer>();
    @CompulsoryJsonProperty
    @JsonAlias(value={"unique_key"})
    private String uniqueKey;
    @JsonIgnore
    public boolean hasRegisteredRecipe = false;

    public Recipe getRecipeAndLazyRegister() {
        ShapelessRecipe recipe = new ShapelessRecipe(new NamespacedKey((Plugin)ConfigurationData.getPlugin(), this.uniqueKey), this.result);
        for (Map.Entry<Material, Integer> entry : this.ingredients.entrySet()) {
            recipe.addIngredient(entry.getValue().intValue(), entry.getKey());
        }
        if (!this.hasRegisteredRecipe) {
            this.hasRegisteredRecipe = true;
            Bukkit.addRecipe((Recipe)recipe);
        }
        return recipe;
    }
}

