/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.data.storage.Storage;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import org.bukkit.configuration.file.YamlConfiguration;

public class LegacyStorage
implements Storage {
    private final YamlConfiguration currentDataYAML;
    private final File currentDataFile;
    private final HeroHandler heroHandler;

    public LegacyStorage() {
        Superheroes superheroes = Superheroes.getInstance();
        this.heroHandler = superheroes.getHeroHandler();
        this.currentDataFile = new File(superheroes.getDataFolder(), "data.yml");
        try {
            this.currentDataFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentDataYAML = YamlConfiguration.loadConfiguration((File)this.currentDataFile);
    }

    @Override
    public List<SuperheroPlayer> exportSuperheroPlayers() {
        ArrayList<SuperheroPlayer> players = new ArrayList<SuperheroPlayer>();
        for (Map.Entry item : this.currentDataYAML.getValues(false).entrySet()) {
            if (!(item.getValue() instanceof String)) continue;
            UUID uuid = UUID.fromString((String)item.getKey());
            players.add(this.loadSuperheroPlayer(uuid));
        }
        return players;
    }

    @Override
    public CompletableFuture<Void> importSuperheroPlayers(List<SuperheroPlayer> imports) {
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public File getCurrentDataFile() {
        return this.currentDataFile;
    }

    @Override
    public void saveSuperheroPlayer(@NotNull SuperheroPlayer superheroPlayer) {
    }

    @Override
    public SuperheroPlayer loadSuperheroPlayer(@NotNull UUID uuid) {
        String superheroName = this.currentDataYAML.getString(uuid.toString());
        Superhero superhero = this.heroHandler.getSuperhero(superheroName);
        return new SuperheroPlayer(uuid, superhero == null ? this.heroHandler.getNoPower() : superhero, 0L);
    }
}

