/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.com.zaxxer.hikari.HikariConfig;
import me.xemor.superheroes.com.zaxxer.hikari.HikariDataSource;
import me.xemor.superheroes.data.ConfigHandler;
import me.xemor.superheroes.data.DatabaseSettings;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.data.storage.Storage;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;

public class MySQLStorage
implements Storage {
    private final HeroHandler heroHandler;
    private final Superheroes superheroes;
    private HikariDataSource source;
    private final ReentrantLock lock = new ReentrantLock();

    public MySQLStorage() {
        this.superheroes = Superheroes.getInstance();
        this.heroHandler = this.superheroes.getHeroHandler();
        this.initMySQLDataSource();
        this.setupTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSuperheroPlayer(@NotNull SuperheroPlayer superheroPlayer) {
        try (Connection conn = this.source.getConnection();
             PreparedStatement stmt = conn.prepareStatement("REPLACE INTO superhero_players(uuid, hero, hero_cmd_timestamp) VALUES(?, ?, ?);");){
            stmt.setString(1, superheroPlayer.getUUID().toString());
            stmt.setString(2, superheroPlayer.getSuperhero().getName());
            stmt.setLong(3, superheroPlayer.getHeroCommandTimestamp());
            this.lock.lock();
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuperheroPlayer loadSuperheroPlayer(@NotNull UUID uuid) {
        try (Connection conn = this.source.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM superhero_players WHERE uuid = ?;");){
            Superhero hero;
            stmt.setString(1, uuid.toString());
            this.lock.lock();
            ResultSet resultSet = stmt.executeQuery();
            if (resultSet.next() && (hero = this.heroHandler.getSuperhero(resultSet.getString("hero"))) != null) {
                SuperheroPlayer superheroPlayer = new SuperheroPlayer(uuid, hero, resultSet.getLong("hero_cmd_timestamp"));
                return superheroPlayer;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> importSuperheroPlayers(List<SuperheroPlayer> superheroPlayers) {
        CompletableFuture completableFuture = new CompletableFuture();
        Superheroes.getScheduling().asyncScheduler().run(() -> {
            for (SuperheroPlayer superheroPlayer : superheroPlayers) {
                this.saveSuperheroPlayer(superheroPlayer);
            }
        });
        return CompletableFuture.allOf(completableFuture);
    }

    @Override
    public List<SuperheroPlayer> exportSuperheroPlayers() {
        ArrayList<SuperheroPlayer> players = new ArrayList<SuperheroPlayer>();
        try (Connection conn = this.source.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM superhero_players;");){
            ResultSet resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Superhero superhero = this.heroHandler.getSuperhero(resultSet.getString(2));
                if (superhero == null) {
                    superhero = this.heroHandler.getNoPower();
                }
                players.add(new SuperheroPlayer(UUID.fromString(resultSet.getString(1)), superhero, resultSet.getLong(3)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return players;
    }

    private void initMySQLDataSource() {
        Properties props = new Properties();
        DatabaseSettings databaseSettings = ConfigHandler.getDatabaseYAML().database();
        props.setProperty("dataSourceClassName", "com.mysql.cj.jdbc.MysqlDataSource");
        props.setProperty("dataSource.serverName", databaseSettings.getHost());
        props.setProperty("dataSource.portNumber", Integer.toString(databaseSettings.getPort()));
        props.setProperty("dataSource.user", databaseSettings.getUsername());
        props.setProperty("dataSource.password", databaseSettings.getPassword());
        props.setProperty("dataSource.databaseName", databaseSettings.getName());
        HikariConfig hikariConfig = new HikariConfig(props);
        hikariConfig.setMaximumPoolSize(2);
        this.source = new HikariDataSource(hikariConfig);
        this.testDataSource(this.source);
    }

    private void testDataSource(DataSource dataSource) {
        try (Connection conn = dataSource.getConnection();){
            if (!conn.isValid(1000)) {
                throw new SQLException("Could not establish database connection.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setupTable() {
        String[] queries;
        String setup;
        try (InputStream in = MySQLStorage.class.getClassLoader().getResourceAsStream("dbsetup.sql");){
            setup = new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            this.superheroes.getLogger().log(Level.SEVERE, "Could not read db setup file.", e);
            e.printStackTrace();
            return;
        }
        for (String query : queries = setup.split(";")) {
            if (query.isEmpty()) continue;
            try (Connection conn = this.source.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.superheroes.getLogger().info("Database setup complete.");
    }
}

