/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.data.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.data.SuperheroPlayer;
import me.xemor.superheroes.data.storage.Storage;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLStorage
implements Storage {
    private final Superheroes superheroes;
    private final HeroHandler heroHandler;
    private final YamlConfiguration currentDataYAML;
    private File currentDataFile;
    private final ReentrantLock yamlLock = new ReentrantLock();

    public YAMLStorage() {
        this.superheroes = Superheroes.getInstance();
        this.heroHandler = this.superheroes.getHeroHandler();
        this.currentDataFile = new File(this.superheroes.getDataFolder(), "data.yml");
        try {
            this.currentDataFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentDataYAML = YamlConfiguration.loadConfiguration((File)this.currentDataFile);
    }

    private ConfigurationSection getSection(UUID uuid) {
        return this.currentDataYAML.getConfigurationSection(String.valueOf(uuid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSuperheroPlayer(@NotNull SuperheroPlayer superheroPlayer) {
        this.yamlLock.lock();
        try {
            ConfigurationSection section = this.getSection(superheroPlayer.getUUID());
            if (section == null) {
                section = this.currentDataYAML.createSection(String.valueOf(superheroPlayer.getUUID()));
            }
            section.set("hero", (Object)superheroPlayer.getSuperhero().getName());
            section.set("hero_cmd_timestamp", (Object)superheroPlayer.getHeroCommandTimestamp());
            this.currentDataYAML.set(String.valueOf(superheroPlayer.getUUID()), (Object)section);
            try {
                this.currentDataYAML.save(this.currentDataFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.yamlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SuperheroPlayer loadSuperheroPlayer(@NotNull UUID uuid) {
        this.yamlLock.lock();
        try {
            ConfigurationSection section = this.getSection(uuid);
            if (section == null) {
                SuperheroPlayer superheroPlayer = null;
                return superheroPlayer;
            }
            String heroName = section.getString("hero", "NOPOWER");
            Superhero superhero = this.heroHandler.getSuperhero(heroName);
            if (superhero == null) {
                SuperheroPlayer superheroPlayer = null;
                return superheroPlayer;
            }
            long heroCommandTimestamp = section.getLong("hero_cmd_timestamp", 0L);
            SuperheroPlayer superheroPlayer = new SuperheroPlayer(uuid, superhero, heroCommandTimestamp);
            return superheroPlayer;
        }
        finally {
            this.yamlLock.unlock();
        }
    }

    @Override
    public CompletableFuture<Void> importSuperheroPlayers(List<SuperheroPlayer> superheroPlayers) {
        this.currentDataFile.renameTo(new File(this.superheroes.getDataFolder(), "old_data.yml"));
        this.currentDataFile = new File(this.superheroes.getDataFolder(), "data.yml");
        for (SuperheroPlayer superheroPlayer : superheroPlayers) {
            this.saveSuperheroPlayer(superheroPlayer);
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    @Override
    public List<SuperheroPlayer> exportSuperheroPlayers() {
        ArrayList<SuperheroPlayer> list = new ArrayList<SuperheroPlayer>();
        for (Map.Entry item : this.currentDataYAML.getValues(false).entrySet()) {
            if (!(item.getValue() instanceof ConfigurationSection)) continue;
            UUID uuid = UUID.fromString((String)item.getKey());
            list.add(this.loadSuperheroPlayer(uuid));
        }
        return list;
    }
}

