/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.hook;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.List;
import javax.annotation.Nullable;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.hook.AbstractBukkitHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.bukkit.hook.BukkitRegionHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.utils.ObjectMatcher;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.lushplugins.libraries.cloplib.operation.OperationType;

public class WorldGuardHook
extends AbstractBukkitHook
implements BukkitRegionHook {
    @Override
    public boolean isOperationAllowed(OperationType operationType, Location location, @Nullable Player player) {
        StateFlag flag = (StateFlag)ObjectMatcher.onFirstMatch(operationType, List.of(new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.BLOCK_PLACE, OperationType.BLOCK_PLACE, OperationType.FARM_BLOCK_PLACE), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.BLOCK_BREAK, OperationType.BLOCK_BREAK, OperationType.FARM_BLOCK_BREAK), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.INTERACT, OperationType.BLOCK_INTERACT, OperationType.REDSTONE_INTERACT), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.PVP, OperationType.PLAYER_DAMAGE_PLAYER), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.DAMAGE_ANIMALS, OperationType.PLAYER_DAMAGE_MONSTER, OperationType.PLAYER_DAMAGE_ENTITY, OperationType.PLAYER_DAMAGE_PERSISTENT_ENTITY, OperationType.PLACE_VEHICLE, OperationType.BREAK_VEHICLE), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.MOB_SPAWNING, OperationType.MONSTER_SPAWN, OperationType.PASSIVE_MOB_SPAWN), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.ENDER_BUILD, OperationType.MONSTER_DAMAGE_TERRAIN), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.CREEPER_EXPLOSION, OperationType.EXPLOSION_DAMAGE_TERRAIN), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.FIREWORK_DAMAGE, OperationType.EXPLOSION_DAMAGE_ENTITY), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.LAVA_FIRE, OperationType.FIRE_BURN), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.FIRE_SPREAD, OperationType.FIRE_SPREAD), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.BLOCK_BREAK, OperationType.FILL_BUCKET, OperationType.EMPTY_BUCKET), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.ENTITY_PAINTING_DESTROY, OperationType.BREAK_HANGING_ENTITY), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.INTERACT, OperationType.FARM_BLOCK_INTERACT), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.MOB_SPAWNING, OperationType.USE_SPAWN_EGG), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.CHORUS_TELEPORT, OperationType.ENDER_PEARL_TELEPORT), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.INTERACT, OperationType.CONTAINER_OPEN), new ObjectMatcher.ObjectRunner<StateFlag>(() -> Flags.DAMAGE_ANIMALS, OperationType.START_RAID)));
        if (flag == null) {
            return true;
        }
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regionManager == null) {
            return true;
        }
        ApplicableRegionSet applicableRegions = regionManager.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        return applicableRegions.getRegions().stream().noneMatch(region -> {
            StateFlag.State state = (StateFlag.State)region.getFlag((Flag)flag);
            return state == null && flag.getDefault() == StateFlag.State.DENY || state == StateFlag.State.DENY;
        });
    }

    @Override
    public boolean hasRegionWithin(Location loc1, Location loc2) {
        ApplicableRegionSet regionSet = this.getRegionsInArea(loc1, loc2);
        return regionSet != null && regionSet.size() > 0;
    }

    @Override
    public boolean ownsAllRegionsWithin(Location loc1, Location loc2, Player player) {
        ApplicableRegionSet regionSet = this.getRegionsInArea(loc1, loc2);
        if (regionSet == null) {
            return true;
        }
        return regionSet.getRegions().stream().allMatch(region -> {
            StateFlag.State state = (StateFlag.State)region.getFlag((Flag)Flags.BLOCK_PLACE);
            return state == null && Flags.BLOCK_PLACE.getDefault() == StateFlag.State.DENY || state == StateFlag.State.DENY;
        });
    }

    private ApplicableRegionSet getRegionsInArea(Location loc1, Location loc2) {
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)loc1.getWorld()));
        if (regionManager == null) {
            return null;
        }
        BlockVector3 min = BlockVector3.at((int)Math.min(loc1.getBlockX(), loc2.getBlockX()), (int)Math.min(loc1.getBlockY(), loc2.getBlockY()), (int)Math.min(loc1.getBlockZ(), loc2.getBlockZ()));
        BlockVector3 max = BlockVector3.at((int)Math.max(loc1.getBlockX(), loc2.getBlockX()), (int)Math.max(loc1.getBlockY(), loc2.getBlockY()), (int)Math.max(loc1.getBlockZ(), loc2.getBlockZ()));
        return regionManager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("unified-protection-check", true, min, max));
    }
}

