/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.lushplugins.unifiedprotection.hook;

import java.util.List;
import java.util.UUID;
import me.xemor.superheroes.lushplugins.unifiedprotection.hook.AbstractHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.hook.RegionHook;
import me.xemor.superheroes.lushplugins.unifiedprotection.player.OnlinePlayer;
import me.xemor.superheroes.lushplugins.unifiedprotection.utils.ChunkUtils;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import net.william278.husktowns.api.HuskTownsAPI;
import net.william278.husktowns.claim.Chunk;
import net.william278.husktowns.claim.TownClaim;
import net.william278.husktowns.claim.World;
import org.lushplugins.libraries.cloplib.operation.Operation;
import org.lushplugins.libraries.cloplib.operation.OperationPosition;
import org.lushplugins.libraries.cloplib.operation.OperationType;
import org.lushplugins.libraries.cloplib.operation.OperationUser;
import org.lushplugins.libraries.cloplib.operation.OperationWorld;

public class HuskTownsHook
extends AbstractHook
implements RegionHook {
    @Override
    public boolean isOperationAllowed(OperationType operationType, OperationPosition position, @Nullable OnlinePlayer player) {
        HuskTownsAPI huskTownsAPI = HuskTownsAPI.getInstance();
        Operation operation = Operation.of((OperationUser)(player != null ? huskTownsAPI.getOnlineUser(player.getUniqueId()) : null), operationType, position);
        return huskTownsAPI.isOperationAllowed(operation);
    }

    @Override
    public boolean hasRegionWithin(OperationPosition pos1, OperationPosition pos2) {
        HuskTownsAPI huskTownsAPI = HuskTownsAPI.getInstance();
        World world = this.getWorld(pos1.getWorld());
        return this.getChunksInArea(pos1, pos2).stream().anyMatch(chunk -> {
            TownClaim claim = huskTownsAPI.getClaimAt(chunk, world).orElse(null);
            return claim != null;
        });
    }

    @Override
    public boolean ownsAllRegionsWithin(OperationPosition pos1, OperationPosition pos2, OnlinePlayer player) {
        HuskTownsAPI huskTownsAPI = HuskTownsAPI.getInstance();
        World world = this.getWorld(pos1.getWorld());
        UUID uuid = player.getUniqueId();
        return this.getChunksInArea(pos1, pos2).stream().allMatch(chunk -> {
            TownClaim claim = huskTownsAPI.getClaimAt(chunk, world).orElse(null);
            if (claim == null) {
                return true;
            }
            return claim.claim().isPlotMember(uuid);
        });
    }

    private List<Chunk> getChunksInArea(OperationPosition pos1, OperationPosition pos2) {
        return ChunkUtils.getChunksInArea(pos1, pos2).stream().map(chunk -> Chunk.at((int)chunk.getX(), (int)chunk.getZ())).toList();
    }

    private World getWorld(OperationWorld world) {
        return World.of((UUID)world.getUuid(), (String)world.getName(), (String)world.getEnvironment());
    }
}

