/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.morepaperlib.scheduling;

import me.xemor.superheroes.morepaperlib.MorePaperLib;
import me.xemor.superheroes.morepaperlib.scheduling.AsynchronousScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.AttachedScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.BukkitSchedulerAsAsynchronousScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.BukkitSchedulerAsRegionalScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.EntitySpecificScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.FoliaDetection;
import me.xemor.superheroes.morepaperlib.scheduling.GlobalAsyncScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.GlobalScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.RegionSpecificScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.RegionalScheduler;
import me.xemor.superheroes.morepaperlib.scheduling.StandardFoliaDetection;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class GracefulScheduling {
    private final MorePaperLib morePaperLib;
    private final FoliaDetection foliaDetection;

    public GracefulScheduling(MorePaperLib morePaperLib, FoliaDetection foliaDetection) {
        this.morePaperLib = morePaperLib;
        this.foliaDetection = foliaDetection;
    }

    public GracefulScheduling(MorePaperLib morePaperLib) {
        this(morePaperLib, StandardFoliaDetection.INSTANCE);
    }

    public boolean isUsingFolia() {
        return this.foliaDetection.isUsingFolia();
    }

    public AsynchronousScheduler asyncScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalAsyncScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsAsynchronousScheduler(this.morePaperLib);
    }

    public RegionalScheduler globalRegionalScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    public RegionalScheduler regionSpecificScheduler(Location location) {
        return this.regionSpecificScheduler(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public RegionalScheduler regionSpecificScheduler(World world, int chunkX, int chunkZ) {
        if (this.isUsingFolia()) {
            return new RegionSpecificScheduler(this.morePaperLib.getPlugin(), world, chunkX, chunkZ);
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    public AttachedScheduler entitySpecificScheduler(Entity entity) {
        if (this.isUsingFolia()) {
            return new EntitySpecificScheduler(entity, this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).asAttachedScheduler();
    }

    public boolean isOnGlobalRegionThread() {
        Server server = this.morePaperLib.getPlugin().getServer();
        if (this.isUsingFolia()) {
            return server.isGlobalTickThread();
        }
        return server.isPrimaryThread();
    }

    public void cancelGlobalTasks() {
        if (this.isUsingFolia()) {
            new GlobalAsyncScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            new GlobalScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            return;
        }
        new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).cancelTasks();
    }
}

