/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.sentry;

import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import me.xemor.sentry.Sentry;
import me.xemor.sentry.SentryEvent;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.protocol.Message;
import org.bukkit.plugin.java.JavaPlugin;

public class SentryLogHandler
extends ConsoleHandler {
    private final JavaPlugin plugin;

    public SentryLogHandler(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void publish(LogRecord record) {
        Throwable exception = record.getThrown();
        if (exception == null) {
            return;
        }
        boolean hasSuperheroesError = false;
        StackTraceElement[] stackTrace = exception.getStackTrace();
        if (stackTrace.length == 0) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            StackTraceElement e = stackTrace[i];
            if (!e.toString().contains("me.xemor.superheroes")) continue;
            hasSuperheroesError = true;
            break;
        }
        if (!hasSuperheroesError) {
            return;
        }
        String message = this.getFormatter().formatMessage(record);
        SentryEvent event = new SentryEvent(exception);
        event.setLevel(SentryLevel.ERROR);
        Message sentryMessage = new Message();
        sentryMessage.setMessage(message);
        event.setMessage(sentryMessage);
        event.setServerName(this.plugin.getServer().getName());
        event.setTag("ServerVersion", this.plugin.getServer().getVersion());
        event.setTag("ServerImplementation", this.plugin.getServer().getBukkitVersion());
        event.setTag("Version", this.plugin.getDescription().getVersion());
        StringBuilder systemName = new StringBuilder();
        systemName.append(System.getProperty("os.name"));
        systemName.append(" ");
        systemName.append(System.getProperty("os.version"));
        systemName.append(" ");
        systemName.append(System.getProperty("os.arch"));
        event.setEnvironment(systemName.toString());
        Sentry.captureEvent(event);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

