/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.BlockRayData;
import me.xemor.superheroes.skills.skilldata.BlockRayMode;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.RayTraceResult;

public class BlockRaySkill
extends SkillImplementation {
    public BlockRaySkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onLookChange(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        Collection<SkillData> skillDatas = superhero.getSkillData("BLOCKRAY");
        for (SkillData skillData : skillDatas) {
            Block block;
            Location eyeLocation;
            BlockRayData blockRayData = (BlockRayData)skillData;
            World world = player.getWorld();
            RayTraceResult rayTraceResult = world.rayTraceBlocks(eyeLocation = player.getEyeLocation(), eyeLocation.getDirection(), (double)blockRayData.getMaxDistance());
            if (rayTraceResult == null || (block = rayTraceResult.getHitBlock()) == null || !blockRayData.getBlocksToReplace().contains(block.getType())) continue;
            Block toChange = blockRayData.getBlockRayMode() == BlockRayMode.ABOVEBLOCK ? block.getRelative(BlockFace.UP) : block;
            skillData.ifConditionsTrue(() -> {
                if (blockRayData.getBlocksToReplace().contains(toChange.getType()) && blockRayData.getBlocksToReplace().contains(block.getType())) {
                    Material originalType = toChange.getType();
                    Material newType = blockRayData.getRandomBlockToPlace();
                    toChange.setType(newType);
                    if (blockRayData.shouldRevert()) {
                        Superheroes.getScheduling().regionSpecificScheduler(toChange.getLocation()).runDelayed(() -> {
                            if (toChange.getType() == newType) {
                                toChange.setType(originalType);
                            }
                        }, blockRayData.getRevertsAfter());
                    }
                }
            }, player, toChange.getLocation());
        }
    }
}

