/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.CreeperData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class CreeperSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public CreeperSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent e) {
        if (e.isSneaking()) {
            Player player = e.getPlayer();
            Superhero superhero = this.heroHandler.getSuperhero(player);
            Collection<SkillData> skillDatas = superhero.getSkillData("CREEPER");
            for (SkillData skillData : skillDatas) {
                CreeperData creeperData = (CreeperData)skillData;
                if (!this.isOnGround(player)) continue;
                int[] timer = new int[]{0};
                World world = player.getWorld();
                if (!this.skillCooldownHandler.isCooldownOver(creeperData, player.getUniqueId())) continue;
                creeperData.ifConditionsTrue(() -> {
                    world.playSound(player.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 1.0f, 1.0f);
                    Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
                        if (!player.isSneaking()) {
                            task.cancel();
                            return;
                        }
                        if (this.heroHandler.getSuperhero(player).getSkillData("CREEPER").isEmpty()) {
                            task.cancel();
                            return;
                        }
                        if (!this.isOnGround(player)) {
                            task.cancel();
                            return;
                        }
                        if ((long)timer[0] >= creeperData.getFuse()) {
                            this.explosion(creeperData, player, world);
                            task.cancel();
                        } else {
                            timer[0] = timer[0] + 1;
                        }
                    }, () -> {}, 1L, 1L);
                }, player, new Object[0]);
            }
        }
    }

    public boolean isOnGround(Player player) {
        return !player.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock().getType().isAir();
    }

    public void explosion(CreeperData creeperData, Player player, World world) {
        world.createExplosion(player.getLocation(), creeperData.getCreeperPower(), false);
        this.skillCooldownHandler.startCooldown(creeperData, creeperData.getCooldown(), player.getUniqueId());
        player.setVelocity(new Vector(0.0, creeperData.getUpwardsVelocity(), 0.0));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, (int)creeperData.getSlowfallDuration(), 0));
    }
}

