/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.UUID;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import me.xemor.superheroes.morepaperlib.scheduling.ScheduledTask;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.EggLayerData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;

public class EggLayerSkill
extends SkillImplementation {
    public final Multimap<UUID, EggLayerRunnable> map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public EggLayerSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onPowerGain(PlayerChangedSuperheroEvent e) {
        this.initialiseSkill(e.getPlayer(), e.getNewHero());
    }

    @EventHandler
    public void onPowerLoss(PlayerChangedSuperheroEvent e) {
        this.removeSkill(e.getPlayer(), e.getOldHero());
    }

    @EventHandler
    public void onPlayerJoin(SuperheroPlayerJoinEvent e) {
        this.initialiseSkill(e.getPlayer(), e.getSuperhero());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.removeSkill(e.getPlayer(), Superheroes.getInstance().getHeroHandler().getSuperhero(e.getPlayer()));
    }

    public void removeSkill(Player player, Superhero oldHero) {
        Collection<SkillData> skillDatas = oldHero.getSkillData("EGGLAYER");
        for (SkillData skillData : skillDatas) {
            Collection eggLayerRunnables = this.map.get((Object)player.getUniqueId());
            for (EggLayerRunnable eggLayerRunnable : eggLayerRunnables) {
                if (skillData != eggLayerRunnable.eggLayerData()) continue;
                eggLayerRunnable.task().cancel();
            }
        }
    }

    public void initialiseSkill(Player player, Superhero superhero) {
        Collection<SkillData> skillDatas = superhero.getSkillData("EGGLAYER");
        for (SkillData skillData : skillDatas) {
            EggLayerData eggLayerData = (EggLayerData)skillData;
            this.startRunnable(player, eggLayerData, superhero);
        }
    }

    public void startRunnable(Player player, EggLayerData eggLayerData, Superhero superhero) {
        ScheduledTask[] taskSingleton;
        ScheduledTask task = Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(() -> {
            Superhero currentPower = this.heroHandler.getSuperhero(player);
            if (!superhero.equals(currentPower)) {
                taskSingleton[0].cancel();
                return;
            }
            if (!superhero.getSkillData("EGGLAYER").contains(eggLayerData)) {
                taskSingleton[0].cancel();
                return;
            }
            eggLayerData.ifConditionsTrue(() -> {
                World world = player.getWorld();
                Location location = player.getLocation();
                world.dropItemNaturally(location, eggLayerData.getToLay());
            }, player, new Object[0]);
        }, () -> {}, eggLayerData.getTickDelay(), eggLayerData.getTickDelay());
        taskSingleton = new ScheduledTask[]{task};
        this.map.put((Object)player.getUniqueId(), (Object)new EggLayerRunnable(eggLayerData, task));
    }

    public record EggLayerRunnable(EggLayerData eggLayerData, ScheduledTask task) {
    }
}

