/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.kyori.adventure.audience.Audience;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.EraserData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.util.RayTraceResult;

public class EraserSkill
extends SkillImplementation {
    private final Superhero erased = new Superhero("ERASED", "<gray><b>ERASED", "Their power has been erased");
    private final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public EraserSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onSight(PlayerToggleSneakEvent e) {
        if (e.isSneaking()) {
            Player player = e.getPlayer();
            Superhero superhero = this.heroHandler.getSuperhero(player);
            Collection<SkillData> skillDatas = superhero.getSkillData("ERASER");
            for (SkillData skillData : skillDatas) {
                Entity entity2;
                EraserData eraserData = (EraserData)skillData;
                if (!this.skillCooldownHandler.isCooldownOver(eraserData, player.getUniqueId())) continue;
                World world = player.getWorld();
                Location eyeLocation = player.getEyeLocation();
                RayTraceResult rayTraceResult = world.rayTrace(eyeLocation = eyeLocation.clone().add(eyeLocation.getDirection()), eyeLocation.getDirection(), eraserData.getRange(), FluidCollisionMode.NEVER, true, 1.0, entity -> entity instanceof Player && !entity.equals((Object)player));
                if (rayTraceResult == null || (entity2 = rayTraceResult.getHitEntity()) == null) continue;
                Player hitPlayer = (Player)entity2;
                skillData.ifConditionsTrue(() -> {
                    this.temporarilyRemoveHero(hitPlayer, player, eraserData);
                    this.skillCooldownHandler.startCooldown(eraserData, eraserData.getCooldown(), player.getUniqueId());
                }, player, hitPlayer);
            }
        }
    }

    public void temporarilyRemoveHero(@NotNull Player player, @Nullable Player remover, EraserData eraserData) {
        Superhero oldPower = this.heroHandler.getSuperhero(player);
        this.heroHandler.setHeroInMemory(player, this.erased);
        Component removedMessage = MiniMessage.miniMessage().deserialize(eraserData.getRemovedMessage(), (TagResolver)Placeholder.unparsed("player", player.getName()));
        if (remover != null) {
            Audience removerAudience = Superheroes.getBukkitAudiences().player(remover);
            removerAudience.sendMessage(removedMessage);
        }
        Audience playerAudience = Superheroes.getBukkitAudiences().player(player);
        playerAudience.sendMessage(removedMessage);
        Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runDelayed(() -> {
            if (this.heroHandler.getSuperhero(player) == this.erased) {
                this.heroHandler.setHeroInMemory(player, oldPower);
                Component returnedMessage = MiniMessage.miniMessage().deserialize(eraserData.getReturnedMessage(), (TagResolver)Placeholder.unparsed("player", player.getName()));
                if (remover != null) {
                    Audience removerAudience = Superheroes.getBukkitAudiences().player(remover);
                    removerAudience.sendMessage(returnedMessage);
                }
                playerAudience.sendMessage(returnedMessage);
            }
        }, () -> {}, eraserData.getDuration());
    }
}

