/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.HeartStealData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;

public class HeartStealSkill
extends SkillImplementation {
    public HeartStealSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onKill(EntityDeathEvent e) {
        Superhero superhero;
        Player player;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            superhero = this.heroHandler.getSuperhero(player);
            this.removeExtraHearts(player, superhero);
        }
        if ((player = e.getEntity().getKiller()) == null) {
            return;
        }
        superhero = this.heroHandler.getSuperhero(player);
        Collection<SkillData> skillDatas = superhero.getSkillData("HEARTSTEAL");
        for (SkillData skillData : skillDatas) {
            HeartStealData heartStealData = (HeartStealData)skillData;
            if (!heartStealData.getEntities().inSet(e.getEntityType())) {
                return;
            }
            heartStealData.ifConditionsTrue(() -> {
                AttributeInstance maxHealth = player.getAttribute(Attribute.MAX_HEALTH);
                if (maxHealth.getValue() >= (double)heartStealData.getMaxHearts()) {
                    return;
                }
                maxHealth.addModifier(new AttributeModifier(new NamespacedKey((Plugin)Superheroes.getInstance(), "Superheroes-HeartSteal" + String.valueOf(UUID.randomUUID())), (double)heartStealData.getHeartsGained(), AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY));
            }, player, e.getEntity());
        }
    }

    public void removeExtraHearts(Player player, Superhero superhero) {
        Collection<SkillData> skillDatas = superhero.getSkillData("HEARTSTEAL");
        if (!skillDatas.isEmpty()) {
            AttributeInstance maxHealth = player.getAttribute(Attribute.MAX_HEALTH);
            ArrayList<AttributeModifier> toRemove = new ArrayList<AttributeModifier>();
            for (AttributeModifier instance : maxHealth.getModifiers()) {
                if (instance.getName().contains("superheroes-heartsteal")) {
                    toRemove.add(instance);
                    continue;
                }
                if (!instance.getKey().getNamespace().equalsIgnoreCase("minecraft") || !instance.getKey().getKey().matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")) continue;
                toRemove.add(instance);
            }
            for (AttributeModifier remove : toRemove) {
                maxHealth.removeModifier(remove);
            }
            if (player.getHealth() > maxHealth.getValue()) {
                player.setHealth(maxHealth.getValue());
            }
        }
    }

    @EventHandler
    public void onSkillLoss(PlayerChangedSuperheroEvent e) {
        this.removeExtraHearts(e.getPlayer(), e.getOldHero());
    }
}

