/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.ArrayList;
import java.util.Collection;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.InstantBreakData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class InstantBreak
extends SkillImplementation {
    public InstantBreak(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (e.getAction() == Action.LEFT_CLICK_BLOCK) {
            Superhero hero = this.getPowersHandler().getSuperhero(e.getPlayer());
            Collection<SkillData> skillDatas = hero.getSkillData("INSTANTBREAK");
            for (SkillData skillData : skillDatas) {
                InstantBreakData instantBreakData = (InstantBreakData)skillData;
                Player player = e.getPlayer();
                Block block = e.getClickedBlock();
                ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
                ItemStack toBreakWith = new ItemStack(instantBreakData.getBreakUsing());
                toBreakWith.addUnsafeEnchantments(item.getEnchantments());
                if (!instantBreakData.canBreak(block.getType())) continue;
                skillData.ifConditionsTrue(() -> {
                    Collection itemStackDrops = block.getDrops(toBreakWith);
                    ArrayList entityDrops = new ArrayList();
                    World world = block.getWorld();
                    itemStackDrops.forEach(itemStack -> entityDrops.add(world.dropItemNaturally(block.getLocation(), itemStack)));
                    BlockDropItemEvent blockDropItemEvent = new BlockDropItemEvent(block, block.getState(), e.getPlayer(), entityDrops);
                    Bukkit.getPluginManager().callEvent((Event)blockDropItemEvent);
                    if (blockDropItemEvent.isCancelled()) {
                        for (Item drop : blockDropItemEvent.getItems()) {
                            drop.remove();
                        }
                    } else {
                        int experience = this.calculateExperience(block.getType());
                        if (experience > 0 && !item.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
                            ExperienceOrb spawn = (ExperienceOrb)world.spawn(block.getLocation(), ExperienceOrb.class);
                            spawn.setExperience(experience);
                        }
                        block.setType(Material.AIR);
                    }
                }, player, block.getLocation());
            }
        }
    }

    public int calculateExperience(Material type) {
        return switch (type) {
            case Material.COAL_ORE, Material.NETHER_GOLD_ORE -> 1;
            case Material.GOLD_ORE, Material.DIAMOND_ORE -> 5;
            case Material.LAPIS_LAZULI, Material.NETHER_QUARTZ_ORE, Material.REDSTONE_ORE -> 3;
            case Material.SPAWNER -> 29;
            default -> 0;
        };
    }
}

