/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import io.papermc.lib.PaperLib;
import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.morepaperlib.scheduling.ScheduledTask;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.PhaseData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PhaseSkill
extends SkillImplementation {
    public PhaseSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onToggleSneak(PlayerToggleSneakEvent e) {
        if (e.isSneaking()) {
            if (!this.onGround(e.getPlayer())) {
                return;
            }
            Player player = e.getPlayer();
            Superhero superhero = this.heroHandler.getSuperhero(player);
            List<PhaseData> phaseDatas = superhero.getSkillData(PhaseData.class);
            for (PhaseData phaseData : phaseDatas) {
                player.setVelocity(new Vector(0.0, -0.1, 0.0));
                Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
                    if (!this.heroHandler.getSuperhero(player).equals(superhero)) {
                        task.cancel();
                        player.setGameMode(GameMode.SURVIVAL);
                        return;
                    }
                    if (player.isSneaking() && player.getLocation().getY() > (double)(player.getWorld().getMinHeight() + 5)) {
                        phaseData.areConditionsTrue(player, new Object[0]).thenAccept(b -> {
                            if (b.booleanValue()) {
                                player.setGameMode(GameMode.SPECTATOR);
                                player.setGravity(true);
                                player.setAllowFlight(false);
                                player.setFlying(false);
                                try {
                                    player.setVelocity(player.getVelocity().normalize());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                            } else {
                                this.elsePath(player, (ScheduledTask)task);
                            }
                        });
                    } else {
                        this.elsePath(player, (ScheduledTask)task);
                    }
                }, () -> {}, 1L, 3L);
            }
        }
    }

    public void elsePath(Player player, ScheduledTask task) {
        if (!player.getAllowFlight()) {
            player.setGameMode(GameMode.SURVIVAL);
            player.removePotionEffect(PotionEffectType.BLINDNESS);
            player.setVelocity(new Vector(0.0, 1.33, 0.0));
            PaperLib.teleportAsync((Entity)player, player.getEyeLocation().add(0.0, 0.35, 0.0));
            if (player.getWorld().getBlockAt(player.getLocation()).isPassable()) {
                task.cancel();
            }
        }
    }

    public boolean onGround(Player player) {
        Location location;
        World world = player.getWorld();
        Block blockBelow = world.getBlockAt(location = player.getLocation()).getRelative(BlockFace.DOWN);
        return !blockBelow.isEmpty();
    }

    @EventHandler
    public void teleport(PlayerTeleportEvent e) {
        if (e.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE && this.heroHandler.getSuperhero(e.getPlayer()).hasSkill("PHASE")) {
            e.setCancelled(true);
        }
    }
}

