/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.PickpocketData;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PickpocketSkill
extends SkillImplementation {
    public PickpocketSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        List<PickpocketData> pickpocketDatas = superhero.getSkillData(PickpocketData.class);
        for (PickpocketData pickpocketData : pickpocketDatas) {
            if (player.isSneaking() != pickpocketData.isSneaking()) {
                return;
            }
            Entity entity = e.getRightClicked();
            if (entity instanceof Player) {
                Player otherPlayer = (Player)entity;
                pickpocketData.ifConditionsTrue(() -> {
                    player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 0.5f);
                    otherPlayer.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 0.5f);
                    PlayerInventory inventory = otherPlayer.getInventory();
                    InventoryView inventoryView = player.openInventory((Inventory)inventory);
                    Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
                        if (inventoryView == null) {
                            task.cancel();
                            return;
                        }
                        if (!superhero.equals(this.heroHandler.getSuperhero(player))) {
                            inventoryView.close();
                            task.cancel();
                            return;
                        }
                        if (!otherPlayer.getWorld().equals((Object)player.getWorld())) {
                            inventoryView.close();
                            task.cancel();
                            return;
                        }
                        if (otherPlayer.getLocation().distanceSquared(player.getLocation()) > pickpocketData.getRangeSquared()) {
                            inventoryView.close();
                            task.cancel();
                        }
                    }, () -> {}, 1L, 4L);
                }, player, otherPlayer);
                continue;
            }
            entity = e.getRightClicked();
            if (!(entity instanceof Villager)) continue;
            Villager villager = (Villager)entity;
            pickpocketData.ifConditionsTrue(() -> {
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 0.5f);
                ItemStack[] contents = villager.getInventory().getContents();
                villager.getInventory().clear();
                for (ItemStack item : contents) {
                    if (item == null) continue;
                    villager.getWorld().dropItemNaturally(player.getLocation(), item);
                }
            }, player, villager);
        }
    }
}

