/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.List;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.PotionGifterSkillData;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class PotionGifterSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public PotionGifterSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        List<PotionGifterSkillData> gifterDatas = superhero.getSkillData(PotionGifterSkillData.class);
        for (PotionGifterSkillData gifterData : gifterDatas) {
            Entity entity = e.getRightClicked();
            if (!this.skillCooldownHandler.isCooldownOver(gifterData, player.getUniqueId()) || !(entity instanceof LivingEntity)) continue;
            LivingEntity lEntity = (LivingEntity)entity;
            gifterData.ifConditionsTrue(() -> {
                World world = lEntity.getWorld();
                world.spawnParticle(Particle.HAPPY_VILLAGER, lEntity.getLocation().add(0.0, 1.0, 0.0), 1);
                gifterData.getPotionEffect().ifPresent(arg_0 -> ((LivingEntity)lEntity).addPotionEffect(arg_0));
                this.skillCooldownHandler.startCooldown(gifterData, gifterData.getCooldown(), player.getUniqueId());
                Component giverMessage = MiniMessage.miniMessage().deserialize(gifterData.getGiverMessage(), (TagResolver)Placeholder.unparsed("player", player.getName()));
                Superheroes.getBukkitAudiences().player(player).sendMessage(giverMessage);
                if (lEntity instanceof Player) {
                    Player receiver = (Player)lEntity;
                    Component receiverMessage = MiniMessage.miniMessage().deserialize(gifterData.getReceiverMessage(), Placeholder.unparsed("gifter", player.getName()), Placeholder.unparsed("player", receiver.getName()));
                    Superheroes.getBukkitAudiences().player(receiver).sendMessage(receiverMessage);
                }
            }, player, lEntity);
        }
    }
}

