/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.List;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.RepulsionData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.util.Vector;

public class RepulsionSkill
extends SkillImplementation {
    public RepulsionSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        Collection<SkillData> skillDatas = this.heroHandler.getSuperhero(player).getSkillData("REPULSION");
        for (SkillData skillData : skillDatas) {
            RepulsionData repulsionData = (RepulsionData)skillData;
            double multiplier = repulsionData.getMultiplier();
            double radius = repulsionData.getRadius();
            Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
                if (!player.isOnline()) {
                    task.cancel();
                    return;
                }
                if (!superhero.equals(this.heroHandler.getSuperhero(player))) {
                    task.cancel();
                    return;
                }
                if (player.isSneaking()) {
                    List nearbyEntities = player.getNearbyEntities(radius, radius, radius);
                    nearbyEntities.stream().filter(entity -> !entity.equals((Object)player)).filter(entity -> repulsionData.allow(entity.getType())).forEach(entity -> skillData.ifConditionsTrue(() -> {
                        Vector distanceVelocity = entity.getLocation().subtract(player.getLocation()).toVector().normalize().multiply(0.1).multiply(multiplier);
                        try {
                            distanceVelocity.checkFinite();
                        }
                        catch (IllegalArgumentException notFinite) {
                            return;
                        }
                        Vector newVelocity = entity.getVelocity().add(distanceVelocity);
                        entity.setVelocity(newVelocity);
                    }, player, entity));
                } else {
                    task.cancel();
                }
            }, () -> {}, 1L, 1L);
        }
    }
}

