/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.SlamData;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class SlamSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public SlamSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onPunch(PlayerInteractEvent e) {
        if (e.getAction() == Action.LEFT_CLICK_AIR) {
            Player player = e.getPlayer();
            Superhero superhero = this.heroHandler.getSuperhero(player);
            List<SlamData> slamDatas = superhero.getSkillData(SlamData.class);
            for (SlamData slamData : slamDatas) {
                UUID uuid;
                ItemStack currentHand = player.getInventory().getItemInMainHand();
                if (currentHand.getType().equals((Object)Material.AIR)) {
                    currentHand = new ItemStack(Material.AIR);
                }
                if (!currentHand.isSimilar(slamData.getHand()) || !this.skillCooldownHandler.isCooldownOver(slamData, uuid = player.getUniqueId()) || player.getFoodLevel() <= slamData.getMinimumFood()) continue;
                slamData.ifConditionsTrue(() -> {
                    this.skillCooldownHandler.startCooldown(slamData, slamData.getAirCooldown(), uuid);
                    player.setFoodLevel(player.getFoodLevel() - slamData.getFoodCost());
                    this.doDoomfistJump(player, superhero, slamData);
                }, player, new Object[0]);
            }
        }
    }

    public void doDoomfistJump(Player player, Superhero superhero, SlamData slamData) {
        player.setVelocity(player.getEyeLocation().getDirection().multiply(1.8).add(new Vector(0.0, 0.5, 0.0)));
        Superheroes.getScheduling().entitySpecificScheduler((Entity)player).runAtFixedRate(task -> {
            Block under = player.getWorld().getBlockAt(player.getLocation().subtract(0.0, 1.0, 0.0));
            if (!this.heroHandler.getSuperhero(player).equals(superhero)) {
                task.cancel();
                return;
            }
            if (!under.getType().isAir()) {
                World world = player.getWorld();
                Collection entities = world.getNearbyEntities(player.getLocation(), slamData.getDiameter(), 3.0, slamData.getDiameter(), entity -> entity instanceof LivingEntity);
                for (Entity entity2 : entities) {
                    if (player.equals((Object)entity2)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity2;
                    if (!(slamData.getDamage() > 0.0)) continue;
                    livingEntity.damage(slamData.getDamage(), (Entity)player);
                }
                this.skillCooldownHandler.startCooldown(slamData, player.getUniqueId());
                task.cancel();
            }
        }, () -> {}, 6L, 2L);
    }
}

