/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.List;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.SummonSkillData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class SummonSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public SummonSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onPunch(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.heroHandler.getSuperhero(player);
        List<SummonSkillData> summonDatas = superhero.getSkillData(SummonSkillData.class);
        for (SummonSkillData summonData : summonDatas) {
            if (!summonData.getAction().contains(e.getAction()) || player.getInventory().getItemInMainHand().getType() != Material.AIR || summonData.mustSneak() != player.isSneaking() || !this.skillCooldownHandler.isCooldownOver(summonData, player.getUniqueId())) continue;
            Location location = this.getRaytraceLocation(player, summonData);
            summonData.ifConditionsTrue(() -> {
                this.summonEntity(location, summonData.getEntityType());
                this.skillCooldownHandler.startCooldown(summonData, player.getUniqueId());
                if (summonData.doesRepel()) {
                    player.setVelocity(player.getEyeLocation().getDirection().multiply(-0.5));
                }
                summonData.getPotionEffect().ifPresent(arg_0 -> ((Player)player).addPotionEffect(arg_0));
            }, player, location);
        }
    }

    public Location getRaytraceLocation(Player player, SummonSkillData summonData) {
        Vector travelVector;
        Location eyeLoc;
        World world = player.getWorld();
        RayTraceResult rayTraceResult = world.rayTraceBlocks(eyeLoc = player.getEyeLocation().clone(), travelVector = eyeLoc.getDirection(), (double)summonData.getRange());
        Vector hitPosition = rayTraceResult == null ? eyeLoc.toVector().add(travelVector.multiply(summonData.getRange())) : rayTraceResult.getHitPosition();
        return new Location(world, hitPosition.getX(), hitPosition.getY(), hitPosition.getZ());
    }

    public void summonEntity(Location location, EntityType entityType) {
        World world = location.getWorld();
        if (entityType == EntityType.LIGHTNING_BOLT) {
            world.strikeLightning(location);
        } else {
            world.spawnEntity(location, entityType);
        }
    }
}

