/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import io.papermc.lib.PaperLib;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.TeleportData;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class TeleportSkill
extends SkillImplementation {
    private final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public TeleportSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        Superhero superhero = this.getPowersHandler().getSuperhero(player);
        List<TeleportData> teleportDatas = superhero.getSkillData(TeleportData.class);
        for (TeleportData teleportData : teleportDatas) {
            if (!teleportData.isValidAction(e.getAction()) || !teleportData.isValidItem(e.getItem()) || !this.skillCooldownHandler.isCooldownOver(teleportData, player.getUniqueId())) continue;
            teleportData.ifConditionsTrue(() -> {
                this.doEnderTeleport(player, teleportData);
                this.skillCooldownHandler.startCooldown(teleportData, teleportData.getCooldown(), player.getUniqueId());
            }, player, new Object[0]);
        }
    }

    public void doEnderTeleport(Player player, TeleportData teleportData) {
        Vector travelVector;
        Location eyeLoc;
        World world = player.getWorld();
        RayTraceResult rayTraceResult = world.rayTraceBlocks(eyeLoc = player.getEyeLocation().clone(), travelVector = eyeLoc.getDirection().setY(eyeLoc.getDirection().getY() * teleportData.getyAxisMultiplier()), (double)teleportData.getDistance());
        Vector hitPosition = rayTraceResult == null ? eyeLoc.toVector().add(travelVector.multiply(teleportData.getDistance())) : rayTraceResult.getHitPosition();
        Location location = new Location(world, hitPosition.getX(), hitPosition.getY(), hitPosition.getZ());
        Location eyeLocation = player.getEyeLocation();
        location.setYaw(eyeLocation.getYaw());
        location.setPitch(eyeLocation.getPitch());
        PaperLib.teleportAsync((Entity)player, location, teleportData.getTeleportCause());
        AtomicInteger count = new AtomicInteger(0);
        if (teleportData.getParticle() != null) {
            Superheroes.getScheduling().regionSpecificScheduler(location).runAtFixedRate(task -> {
                teleportData.getParticle().spawnParticle((LivingEntity)player);
                count.addAndGet(1);
                if (count.get() == 5) {
                    task.cancel();
                }
            }, 1L, 1L);
        }
    }
}

