/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.implementations;

import java.util.List;
import me.xemor.superheroes.SkillCooldownHandler;
import me.xemor.superheroes.data.HeroHandler;
import me.xemor.superheroes.skills.implementations.SkillImplementation;
import me.xemor.superheroes.skills.skilldata.ThrowerData;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class ThrowerSkill
extends SkillImplementation {
    final SkillCooldownHandler skillCooldownHandler = new SkillCooldownHandler();

    public ThrowerSkill(HeroHandler heroHandler) {
        super(heroHandler);
    }

    @EventHandler
    public void onThrow(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        List<ThrowerData> throwerDatas = this.heroHandler.getSuperhero(player).getSkillData(ThrowerData.class);
        for (ThrowerData throwerData : throwerDatas) {
            ItemStack item;
            if (!throwerData.getActions().contains(e.getAction()) || (item = e.getItem()) == null || item.getAmount() < throwerData.getAmmoCost() || !throwerData.getAmmo().matches(item) || !this.skillCooldownHandler.isCooldownOver(throwerData, player.getUniqueId())) continue;
            e.setCancelled(true);
            throwerData.ifConditionsTrue(() -> {
                EntityType entityType = throwerData.getProjectile();
                World world = player.getWorld();
                Entity entity = world.spawnEntity(player.getEyeLocation(), entityType);
                entity.setVelocity(player.getEyeLocation().getDirection().multiply(throwerData.getVelocity()));
                if (entity instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)entity;
                    arrow.setPickupStatus(throwerData.canPickUp());
                    arrow.setDamage(throwerData.getDamage());
                }
                if (entity instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    projectile.setShooter((ProjectileSource)player);
                }
                this.useAmmo(throwerData.getAmmoCost(), item);
                this.skillCooldownHandler.startCooldown(throwerData, throwerData.getCooldown(), player.getUniqueId());
            }, player, new Object[0]);
        }
    }

    public void useAmmo(int cost, ItemStack item) {
        int paidFor = 0;
        if (item.getAmount() >= cost - paidFor) {
            item.setAmount(item.getAmount() - (cost - paidFor));
        } else {
            paidFor += item.getAmount();
            item.setType(Material.AIR);
        }
    }
}

