/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.skilldata;

import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.comparison.SetData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageModifierData
extends SkillData {
    @JsonPropertyWithDefault
    private SetData<EntityType> entities = new SetData();
    @JsonPropertyWithDefault
    private SetData<EntityDamageEvent.DamageCause> causes = new SetData();
    @JsonPropertyWithDefault
    private boolean whitelist = false;
    @JsonPropertyWithDefault
    private double expectedMaxDamage = 30.0;
    @JsonPropertyWithDefault
    private double maxDamage = 15.0;
    @JsonPropertyWithDefault
    private double minDamage = 0.0;
    @JsonPropertyWithDefault
    private int priority = 0;
    @JsonPropertyWithDefault
    private boolean incoming = false;
    @JsonPropertyWithDefault
    private boolean outgoing = false;
    @JsonPropertyWithDefault
    private boolean eased = false;
    @JsonPropertyWithDefault
    private boolean limitProjectiles = true;

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean limitProjectiles() {
        return this.limitProjectiles;
    }

    public boolean isValidCause(EntityDamageEvent.DamageCause damageCause) {
        boolean in = this.causes.getSet().contains(damageCause);
        if (!this.whitelist) {
            in = !in;
        }
        return in;
    }

    public boolean isValidEntity(EntityType entityType) {
        boolean in = this.entities.getSet().contains(entityType);
        if (!this.whitelist) {
            in = !in;
        }
        return in;
    }

    public double calculateDamage(double damage) {
        if (damage < this.minDamage) {
            damage = this.minDamage;
        }
        if (this.eased) {
            return damage > this.expectedMaxDamage ? this.maxDamage : this.maxDamage * (1.0 - (1.0 - damage / this.expectedMaxDamage) * (1.0 - damage / this.expectedMaxDamage));
        }
        return Math.min(Math.max(damage, this.minDamage), this.maxDamage);
    }
}

