/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.skilldata;

import com.fasterxml.jackson.annotation.JsonAlias;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.xemor.superheroes.configurationdata.Duration;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.comparison.SetData;
import me.xemor.superheroes.skills.skilldata.SkillData;
import org.bukkit.Material;

public class WalkerData
extends SkillData {
    @JsonPropertyWithDefault
    private List<Material> blocksToPlace = new ArrayList<Material>();
    @JsonPropertyWithDefault
    private Set<Material> blocksToReplace = new HashSet<Material>();
    @JsonPropertyWithDefault
    private SetData<Material> blocksToPlaceOn = new SetData();
    @JsonPropertyWithDefault
    @JsonAlias(value={"sneaking", "issneaking"})
    private boolean isSneaking = false;
    @JsonPropertyWithDefault
    private boolean blocksDrop = true;
    @JsonPropertyWithDefault
    private boolean shouldRevert = false;
    @JsonPropertyWithDefault
    private boolean aboveFloor = false;
    @JsonPropertyWithDefault
    private boolean canPlaceFloating = true;
    @JsonPropertyWithDefault
    private Duration revertsAfter = new Duration(15.0);

    public Material getReplacementBlock() {
        return this.blocksToPlace.get(ThreadLocalRandom.current().nextInt(this.blocksToPlace.size()));
    }

    public boolean shouldReplace(Material material) {
        return this.blocksToReplace.contains(material);
    }

    public boolean isSneaking() {
        return this.isSneaking;
    }

    public boolean doesBlockDrop() {
        return this.blocksDrop;
    }

    public boolean shouldRevert() {
        return this.shouldRevert;
    }

    public long getRevertsAfter() {
        return this.revertsAfter.getDurationInTicks().orElse(300L);
    }

    public boolean isAboveFloor() {
        return this.aboveFloor;
    }

    public boolean canPlaceFloating() {
        return this.canPlaceFloating;
    }

    public boolean canPlaceOn(Material type) {
        return this.blocksToPlaceOn.inSet(type);
    }
}

