/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.skills.skilldata.spell;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import javax.annotation.Nullable;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.xemor.superheroes.skills.skilldata.SkillData;
import me.xemor.superheroes.skills.skilldata.configdata.Cooldown;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="skill")
public abstract class SpellData
extends SkillData
implements Cooldown {
    @JsonPropertyWithDefault
    private Material fuel = Material.REDSTONE;
    @JsonPropertyWithDefault
    private String spellName = this.getClass().getName();
    @JsonPropertyWithDefault
    @JsonAlias(value={"displayNameFormat"})
    private String displayName = "<purple><spellName>";
    @JsonPropertyWithDefault
    private String cooldownMessage = "<spellName> has <currentcooldown> seconds remaining.";
    @JsonPropertyWithDefault
    private String moreFuelMessage = "This spell needs <fuelneeded> more <fuel>";
    @JsonPropertyWithDefault
    private double cooldown = 1.0;
    @JsonPropertyWithDefault
    private int cost = 1;
    @JsonPropertyWithDefault
    @JsonAlias(value={"loreFormat"})
    private List<String> lore = List.of();

    private String replaceVariables(String input) {
        return LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().build().serialize(MiniMessage.miniMessage().deserialize(input, Placeholder.unparsed("spellname", this.spellName), Placeholder.unparsed("cooldown", String.valueOf(this.cooldown)), Placeholder.unparsed("fuel", String.valueOf(this.fuel)), Placeholder.unparsed("cost", String.valueOf(this.cost))));
    }

    public abstract boolean castSpell(Player var1, @Nullable Block var2, @Nullable BlockFace var3);

    public Material getFuel() {
        return this.fuel;
    }

    @Override
    public double getCooldown() {
        return this.cooldown;
    }

    public int getCost() {
        return this.cost;
    }

    public String getSpellName() {
        return this.spellName;
    }

    public List<String> getLore() {
        return this.lore.stream().map(this::replaceVariables).toList();
    }

    public String getDisplayName() {
        return this.replaceVariables(this.displayName);
    }

    public String getMoreFuelMessage() {
        return this.moreFuelMessage;
    }

    @Override
    public String getCooldownMessage() {
        return this.cooldownMessage;
    }
}

