/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.libraries.cloplib.operation;

import java.util.Optional;
import lombok.Generated;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import org.lushplugins.libraries.cloplib.operation.OperationPosition;
import org.lushplugins.libraries.cloplib.operation.OperationType;
import org.lushplugins.libraries.cloplib.operation.OperationUser;

public class Operation {
    private final OperationType type;
    private final OperationPosition position;
    @Nullable
    private final OperationUser user;
    @Nullable
    private final OperationUser victim;
    private boolean silent;

    @ApiStatus.Internal
    private Operation(@Nullable OperationUser user, @Nullable OperationUser victim, @NotNull OperationType type, @NotNull OperationPosition position) {
        this.user = user;
        this.victim = victim;
        this.type = type;
        this.position = position;
        this.silent = this.getType().isSilent();
    }

    @ApiStatus.Internal
    private Operation(@Nullable OperationUser user, @NotNull OperationType type, @NotNull OperationPosition position) {
        this(user, null, type, position);
    }

    @ApiStatus.Internal
    private Operation(@NotNull OperationType type, @NotNull OperationPosition position) {
        this(null, null, type, position);
    }

    @NotNull
    public static Operation of(@Nullable OperationUser user, @NotNull OperationType type, @NotNull OperationPosition position) {
        return new Operation(user, type, position);
    }

    @NotNull
    public static Operation of(@NotNull OperationType type, @NotNull OperationPosition position) {
        return new Operation(type, position);
    }

    @NotNull
    public static Operation of(@Nullable OperationUser user, @NotNull OperationType type, @NotNull OperationPosition position, boolean silent) {
        Operation operation = Operation.of(user, type, position);
        operation.setSilent(silent);
        return operation;
    }

    @NotNull
    public static Operation of(@Nullable OperationUser user, @Nullable OperationUser victim, @NotNull OperationType type, @NotNull OperationPosition position) {
        return new Operation(user, victim, type, position);
    }

    @NotNull
    public static Operation of(@NotNull OperationType type, @NotNull OperationPosition position, boolean silent) {
        Operation operation = Operation.of(type, position);
        operation.setSilent(silent);
        return operation;
    }

    private void setSilent(boolean silent) {
        this.silent = silent;
    }

    @NotNull
    public OperationType getType() {
        return this.type;
    }

    public boolean isVerbose() {
        return !this.silent;
    }

    @NotNull
    public OperationPosition getOperationPosition() {
        return this.position;
    }

    public Optional<OperationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public Optional<OperationUser> getVictim() {
        return Optional.ofNullable(this.victim);
    }

    @Generated
    private Operation(OperationType type, OperationPosition position, @Nullable OperationUser user, @Nullable OperationUser victim, boolean silent) {
        this.type = type;
        this.position = position;
        this.user = user;
        this.victim = victim;
        this.silent = silent;
    }
}

