/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.libraries.cloplib.operation;

import de.exlll.configlib.SerializeWith;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import me.xemor.superheroes.kyori.adventure.key.Key;
import me.xemor.superheroes.kyori.adventure.key.KeyPattern;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.org.jetbrains.annotations.Unmodifiable;
import org.lushplugins.libraries.cloplib.operation.OperationTypeConfigSerializer;

@SerializeWith(serializer=OperationTypeConfigSerializer.class)
public final class OperationType {
    @KeyPattern.Namespace
    private static final String DEFAULT_NAMESPACE = "cloplib";
    private static final Map<String, OperationType> REGISTRY = new HashMap<String, OperationType>();
    public static final OperationType BLOCK_PLACE = OperationType.registerBuiltin("block_place");
    public static final OperationType BLOCK_BREAK = OperationType.registerBuiltin("block_break");
    public static final OperationType BLOCK_INTERACT = OperationType.registerBuiltin("block_interact");
    public static final OperationType REDSTONE_INTERACT = OperationType.registerBuiltin("redstone_interact", true);
    public static final OperationType FARM_BLOCK_BREAK = OperationType.registerBuiltin("farm_block_break");
    public static final OperationType FARM_BLOCK_PLACE = OperationType.registerBuiltin("farm_block_place");
    public static final OperationType PLAYER_DAMAGE_PLAYER = OperationType.registerBuiltin("player_damage_player");
    public static final OperationType PLAYER_DAMAGE_MONSTER = OperationType.registerBuiltin("player_damage_monster");
    public static final OperationType PLAYER_DAMAGE_ENTITY = OperationType.registerBuiltin("player_damage_entity");
    public static final OperationType PLAYER_DAMAGE_PERSISTENT_ENTITY = OperationType.registerBuiltin("player_damage_persistent_entity");
    public static final OperationType MONSTER_SPAWN = OperationType.registerBuiltin("monster_spawn", true);
    public static final OperationType PASSIVE_MOB_SPAWN = OperationType.registerBuiltin("passive_mob_spawn", true);
    public static final OperationType MONSTER_DAMAGE_TERRAIN = OperationType.registerBuiltin("monster_damage_terrain", true);
    public static final OperationType EXPLOSION_DAMAGE_TERRAIN = OperationType.registerBuiltin("explosion_damage_terrain", true);
    public static final OperationType EXPLOSION_DAMAGE_ENTITY = OperationType.registerBuiltin("explosion_damage_entity", true);
    public static final OperationType FIRE_BURN = OperationType.registerBuiltin("fire_burn", true);
    public static final OperationType FIRE_SPREAD = OperationType.registerBuiltin("fire_spread", true);
    public static final OperationType FILL_BUCKET = OperationType.registerBuiltin("fill_bucket");
    public static final OperationType EMPTY_BUCKET = OperationType.registerBuiltin("empty_bucket");
    public static final OperationType PLACE_HANGING_ENTITY = OperationType.registerBuiltin("place_hanging_entity");
    public static final OperationType BREAK_HANGING_ENTITY = OperationType.registerBuiltin("break_hanging_entity");
    public static final OperationType PLACE_VEHICLE = OperationType.registerBuiltin("place_vehicle");
    public static final OperationType BREAK_VEHICLE = OperationType.registerBuiltin("break_vehicle");
    public static final OperationType ENTITY_INTERACT = OperationType.registerBuiltin("entity_interact");
    public static final OperationType FARM_BLOCK_INTERACT = OperationType.registerBuiltin("farm_block_interact");
    public static final OperationType USE_SPAWN_EGG = OperationType.registerBuiltin("use_spawn_egg");
    public static final OperationType ENDER_PEARL_TELEPORT = OperationType.registerBuiltin("ender_pearl_teleport");
    public static final OperationType CONTAINER_OPEN = OperationType.registerBuiltin("container_open");
    public static final OperationType START_RAID = OperationType.registerBuiltin("start_raid");
    private final boolean silent;
    private final Key key;
    private final int ordinal;

    private OperationType(@NotNull Key key, boolean silent) {
        this.silent = silent;
        this.key = key;
        this.ordinal = REGISTRY.size();
    }

    @NotNull
    public static OperationType register(@NotNull OperationType type) {
        assert (REGISTRY != null) : "Registry was null";
        if (OperationType.isRegistered(type.getKey())) {
            throw new IllegalArgumentException("Operation type already registered: %s".formatted(type.getKey()));
        }
        REGISTRY.put(type.getKey().asString(), type);
        return type;
    }

    @NotNull
    public static OperationType unregister(@NotNull Key key) {
        assert (REGISTRY != null) : "Registry was null";
        if (!OperationType.isRegistered(key)) {
            throw new IllegalArgumentException("Operation type not registered: %s".formatted(key));
        }
        return REGISTRY.remove(key.asString());
    }

    @NotNull
    public static OperationType create(@NotNull Key key, boolean silent) {
        return new OperationType(key, silent);
    }

    public static Optional<OperationType> get(@NotNull Key key) {
        return Optional.ofNullable(REGISTRY.get(key.asString()));
    }

    public static Optional<OperationType> get(@NotNull String key) {
        return Optional.ofNullable(REGISTRY.get(OperationType.formatKeyString(key)));
    }

    @NotNull
    public static OperationType getOrCreate(@Nullable String key) {
        String keyString = OperationType.formatKeyString(key);
        return REGISTRY.getOrDefault(keyString, OperationType.create(Key.key(keyString), false));
    }

    public static boolean isRegistered(@NotNull Key key) {
        return REGISTRY.containsKey(key.asString());
    }

    public static boolean isRegistered(@NotNull String key) {
        return REGISTRY.containsKey(OperationType.formatKeyString(key));
    }

    @NotNull
    public static @Unmodifiable Collection<OperationType> getRegistered() {
        return REGISTRY.values();
    }

    @Deprecated(since="2.0")
    @NotNull
    public static @Unmodifiable OperationType[] values() {
        return REGISTRY.values().toArray(new OperationType[0]);
    }

    @Deprecated(since="2.0")
    public static Optional<OperationType> fromId(@NotNull String id) {
        return OperationType.get(id);
    }

    @Deprecated(since="2.0")
    public static OperationType valueOf(@NotNull String id) {
        return OperationType.get(id).orElseThrow(() -> new IllegalArgumentException("Invalid operation ID: %s".formatted(id)));
    }

    @NotNull
    @KeyPattern
    private static String formatKeyString(@Nullable String key) {
        Object keyString;
        if (key == null) {
            throw new IllegalArgumentException("Operation Type key is null");
        }
        Object object = keyString = !key.contains(":") ? "cloplib:" + key.toLowerCase(Locale.ENGLISH) : key.toLowerCase(Locale.ENGLISH);
        if (!Key.parseable((String)keyString)) {
            throw new IllegalArgumentException("Invalid operation type key: %s".formatted(key));
        }
        return keyString;
    }

    @NotNull
    private static OperationType registerBuiltin(@NotNull @KeyPattern.Value String name, boolean silent) {
        return OperationType.register(OperationType.create(Key.key(DEFAULT_NAMESPACE, name), silent));
    }

    @NotNull
    private static OperationType registerBuiltin(@NotNull @KeyPattern.Value String name) {
        return OperationType.registerBuiltin(name, false);
    }

    @NotNull
    public String toString() {
        return this.getKey().asString();
    }

    @NotNull
    public String asMinimalString() {
        if (this.getKey().namespace().equals(DEFAULT_NAMESPACE)) {
            return this.getKey().value();
        }
        return this.getKey().asString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperationType) {
            OperationType other = (OperationType)obj;
            return this.asMinimalString().equals(other.asMinimalString());
        }
        return false;
    }

    public int hashCode() {
        return this.asMinimalString().hashCode();
    }

    @Deprecated(since="2.0")
    @NotNull
    public String name() {
        return this.key.value().toUpperCase(Locale.ENGLISH);
    }

    @Deprecated(since="2.0")
    public int ordinal() {
        return this.ordinal;
    }

    @Generated
    public boolean isSilent() {
        return this.silent;
    }

    @Generated
    public Key getKey() {
        return this.key;
    }
}

