/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import me.xemor.sentry.util.Objects;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

final class HostnameCache {
    private static final long HOSTNAME_CACHE_DURATION = TimeUnit.HOURS.toMillis(5L);
    private static final long GET_HOSTNAME_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    @Nullable
    private static HostnameCache INSTANCE;
    private final long cacheDuration;
    @Nullable
    private volatile String hostname;
    private volatile long expirationTimestamp;
    @NotNull
    private final AtomicBoolean updateRunning = new AtomicBoolean(false);
    @NotNull
    private final Callable<InetAddress> getLocalhost;
    @NotNull
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new HostnameCacheThreadFactory());

    @NotNull
    static HostnameCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostnameCache();
        }
        return INSTANCE;
    }

    private HostnameCache() {
        this(HOSTNAME_CACHE_DURATION);
    }

    HostnameCache(long cacheDuration) {
        this(cacheDuration, () -> InetAddress.getLocalHost());
    }

    HostnameCache(long cacheDuration, @NotNull Callable<InetAddress> getLocalhost) {
        this.cacheDuration = cacheDuration;
        this.getLocalhost = Objects.requireNonNull(getLocalhost, "getLocalhost is required");
        this.updateCache();
    }

    void close() {
        this.executorService.shutdown();
    }

    boolean isClosed() {
        return this.executorService.isShutdown();
    }

    @Nullable
    String getHostname() {
        if (this.expirationTimestamp < System.currentTimeMillis() && this.updateRunning.compareAndSet(false, true)) {
            this.updateCache();
        }
        return this.hostname;
    }

    private void updateCache() {
        Callable<Void> hostRetriever = () -> {
            try {
                this.hostname = this.getLocalhost.call().getCanonicalHostName();
                this.expirationTimestamp = System.currentTimeMillis() + this.cacheDuration;
            }
            finally {
                this.updateRunning.set(false);
            }
            return null;
        };
        try {
            Future<Void> futureTask = this.executorService.submit(hostRetriever);
            futureTask.get(GET_HOSTNAME_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.handleCacheUpdateFailure();
        }
        catch (RuntimeException | ExecutionException | TimeoutException e) {
            this.handleCacheUpdateFailure();
        }
    }

    private void handleCacheUpdateFailure() {
        this.expirationTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(1L);
    }

    private static final class HostnameCacheThreadFactory
    implements ThreadFactory {
        private int cnt;

        private HostnameCacheThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread ret = new Thread(r, "SentryHostnameCache-" + this.cnt++);
            ret.setDaemon(true);
            return ret;
        }
    }
}

