/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.xemor.sentry.Breadcrumb;
import me.xemor.sentry.ISerializer;
import me.xemor.sentry.JsonDeserializer;
import me.xemor.sentry.JsonObjectReader;
import me.xemor.sentry.JsonObjectWriter;
import me.xemor.sentry.ProfilingTraceData;
import me.xemor.sentry.ProfilingTransactionData;
import me.xemor.sentry.SentryEnvelope;
import me.xemor.sentry.SentryEnvelopeHeader;
import me.xemor.sentry.SentryEnvelopeItem;
import me.xemor.sentry.SentryEnvelopeItemHeader;
import me.xemor.sentry.SentryEvent;
import me.xemor.sentry.SentryItemType;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.SentryLockReason;
import me.xemor.sentry.SentryOptions;
import me.xemor.sentry.Session;
import me.xemor.sentry.SpanContext;
import me.xemor.sentry.SpanId;
import me.xemor.sentry.SpanStatus;
import me.xemor.sentry.UserFeedback;
import me.xemor.sentry.clientreport.ClientReport;
import me.xemor.sentry.profilemeasurements.ProfileMeasurement;
import me.xemor.sentry.profilemeasurements.ProfileMeasurementValue;
import me.xemor.sentry.protocol.App;
import me.xemor.sentry.protocol.Browser;
import me.xemor.sentry.protocol.Contexts;
import me.xemor.sentry.protocol.DebugImage;
import me.xemor.sentry.protocol.DebugMeta;
import me.xemor.sentry.protocol.Device;
import me.xemor.sentry.protocol.Geo;
import me.xemor.sentry.protocol.Gpu;
import me.xemor.sentry.protocol.MeasurementValue;
import me.xemor.sentry.protocol.Mechanism;
import me.xemor.sentry.protocol.Message;
import me.xemor.sentry.protocol.OperatingSystem;
import me.xemor.sentry.protocol.Request;
import me.xemor.sentry.protocol.SdkInfo;
import me.xemor.sentry.protocol.SdkVersion;
import me.xemor.sentry.protocol.SentryException;
import me.xemor.sentry.protocol.SentryPackage;
import me.xemor.sentry.protocol.SentryRuntime;
import me.xemor.sentry.protocol.SentrySpan;
import me.xemor.sentry.protocol.SentryStackFrame;
import me.xemor.sentry.protocol.SentryStackTrace;
import me.xemor.sentry.protocol.SentryThread;
import me.xemor.sentry.protocol.SentryTransaction;
import me.xemor.sentry.protocol.User;
import me.xemor.sentry.protocol.ViewHierarchy;
import me.xemor.sentry.protocol.ViewHierarchyNode;
import me.xemor.sentry.util.Objects;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

public final class JsonSerializer
implements ISerializer {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Map<Class<?>, JsonDeserializer<?>> deserializersByClass;

    public JsonSerializer(@NotNull SentryOptions options) {
        this.options = options;
        this.deserializersByClass = new HashMap();
        this.deserializersByClass.put(App.class, new App.Deserializer());
        this.deserializersByClass.put(Breadcrumb.class, new Breadcrumb.Deserializer());
        this.deserializersByClass.put(Browser.class, new Browser.Deserializer());
        this.deserializersByClass.put(Contexts.class, new Contexts.Deserializer());
        this.deserializersByClass.put(DebugImage.class, new DebugImage.Deserializer());
        this.deserializersByClass.put(DebugMeta.class, new DebugMeta.Deserializer());
        this.deserializersByClass.put(Device.class, new Device.Deserializer());
        this.deserializersByClass.put(Device.DeviceOrientation.class, new Device.DeviceOrientation.Deserializer());
        this.deserializersByClass.put(Gpu.class, new Gpu.Deserializer());
        this.deserializersByClass.put(MeasurementValue.class, new MeasurementValue.Deserializer());
        this.deserializersByClass.put(Mechanism.class, new Mechanism.Deserializer());
        this.deserializersByClass.put(Message.class, new Message.Deserializer());
        this.deserializersByClass.put(OperatingSystem.class, new OperatingSystem.Deserializer());
        this.deserializersByClass.put(ProfilingTraceData.class, new ProfilingTraceData.Deserializer());
        this.deserializersByClass.put(ProfilingTransactionData.class, new ProfilingTransactionData.Deserializer());
        this.deserializersByClass.put(ProfileMeasurement.class, new ProfileMeasurement.Deserializer());
        this.deserializersByClass.put(ProfileMeasurementValue.class, new ProfileMeasurementValue.Deserializer());
        this.deserializersByClass.put(Request.class, new Request.Deserializer());
        this.deserializersByClass.put(SdkInfo.class, new SdkInfo.Deserializer());
        this.deserializersByClass.put(SdkVersion.class, new SdkVersion.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeHeader.class, new SentryEnvelopeHeader.Deserializer());
        this.deserializersByClass.put(SentryEnvelopeItemHeader.class, new SentryEnvelopeItemHeader.Deserializer());
        this.deserializersByClass.put(SentryEvent.class, new SentryEvent.Deserializer());
        this.deserializersByClass.put(SentryException.class, new SentryException.Deserializer());
        this.deserializersByClass.put(SentryItemType.class, new SentryItemType.Deserializer());
        this.deserializersByClass.put(SentryLevel.class, new SentryLevel.Deserializer());
        this.deserializersByClass.put(SentryLockReason.class, new SentryLockReason.Deserializer());
        this.deserializersByClass.put(SentryPackage.class, new SentryPackage.Deserializer());
        this.deserializersByClass.put(SentryRuntime.class, new SentryRuntime.Deserializer());
        this.deserializersByClass.put(SentrySpan.class, new SentrySpan.Deserializer());
        this.deserializersByClass.put(SentryStackFrame.class, new SentryStackFrame.Deserializer());
        this.deserializersByClass.put(SentryStackTrace.class, new SentryStackTrace.Deserializer());
        this.deserializersByClass.put(SentryThread.class, new SentryThread.Deserializer());
        this.deserializersByClass.put(SentryTransaction.class, new SentryTransaction.Deserializer());
        this.deserializersByClass.put(Session.class, new Session.Deserializer());
        this.deserializersByClass.put(SpanContext.class, new SpanContext.Deserializer());
        this.deserializersByClass.put(SpanId.class, new SpanId.Deserializer());
        this.deserializersByClass.put(SpanStatus.class, new SpanStatus.Deserializer());
        this.deserializersByClass.put(User.class, new User.Deserializer());
        this.deserializersByClass.put(Geo.class, new Geo.Deserializer());
        this.deserializersByClass.put(UserFeedback.class, new UserFeedback.Deserializer());
        this.deserializersByClass.put(ClientReport.class, new ClientReport.Deserializer());
        this.deserializersByClass.put(ViewHierarchyNode.class, new ViewHierarchyNode.Deserializer());
        this.deserializersByClass.put(ViewHierarchy.class, new ViewHierarchy.Deserializer());
    }

    @Override
    @Nullable
    public <T, R> T deserializeCollection(@NotNull Reader reader, @NotNull Class<T> clazz, @Nullable JsonDeserializer<R> elementDeserializer) {
        try {
            JsonObjectReader jsonObjectReader = new JsonObjectReader(reader);
            if (Collection.class.isAssignableFrom(clazz)) {
                if (elementDeserializer == null) {
                    return (T)jsonObjectReader.nextObjectOrNull();
                }
                return (T)jsonObjectReader.nextList(this.options.getLogger(), elementDeserializer);
            }
            return (T)jsonObjectReader.nextObjectOrNull();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", e);
            return null;
        }
    }

    @Override
    @Nullable
    public <T> T deserialize(@NotNull Reader reader, @NotNull Class<T> clazz) {
        try {
            JsonObjectReader jsonObjectReader = new JsonObjectReader(reader);
            JsonDeserializer<?> deserializer = this.deserializersByClass.get(clazz);
            if (deserializer != null) {
                Object object = deserializer.deserialize(jsonObjectReader, this.options.getLogger());
                return clazz.cast(object);
            }
            if (this.isKnownPrimitive(clazz)) {
                return (T)jsonObjectReader.nextObjectOrNull();
            }
            return null;
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when deserializing", e);
            return null;
        }
    }

    @Override
    @Nullable
    public SentryEnvelope deserializeEnvelope(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "The InputStream object is required.");
        try {
            return this.options.getEnvelopeReader().read(inputStream);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error deserializing envelope.", e);
            return null;
        }
    }

    @Override
    public <T> void serialize(@NotNull T entity, @NotNull Writer writer) throws IOException {
        Objects.requireNonNull(entity, "The entity is required.");
        Objects.requireNonNull(writer, "The Writer object is required.");
        if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
            String serialized = this.serializeToString(entity, this.options.isEnablePrettySerializationOutput());
            this.options.getLogger().log(SentryLevel.DEBUG, "Serializing object: %s", serialized);
        }
        JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(writer, this.options.getMaxDepth());
        jsonObjectWriter.value(this.options.getLogger(), entity);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(@NotNull SentryEnvelope envelope, @NotNull OutputStream outputStream) throws Exception {
        Objects.requireNonNull(envelope, "The SentryEnvelope object is required.");
        Objects.requireNonNull(outputStream, "The Stream object is required.");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, UTF_8));
        try {
            envelope.getHeader().serialize(new JsonObjectWriter(writer, this.options.getMaxDepth()), this.options.getLogger());
            writer.write("\n");
            for (SentryEnvelopeItem item : envelope.getItems()) {
                try {
                    byte[] data = item.getData();
                    item.getHeader().serialize(new JsonObjectWriter(writer, this.options.getMaxDepth()), this.options.getLogger());
                    writer.write("\n");
                    ((Writer)writer).flush();
                    outputStream.write(data);
                    writer.write("\n");
                }
                catch (Exception exception) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Failed to create envelope item. Dropping it.", exception);
                }
            }
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    @Override
    @NotNull
    public String serialize(@NotNull Map<String, Object> data) throws Exception {
        return this.serializeToString(data, false);
    }

    @NotNull
    private String serializeToString(Object object, boolean pretty) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonObjectWriter jsonObjectWriter = new JsonObjectWriter(stringWriter, this.options.getMaxDepth());
        if (pretty) {
            jsonObjectWriter.setIndent("\t");
        }
        jsonObjectWriter.value(this.options.getLogger(), object);
        return stringWriter.toString();
    }

    private <T> boolean isKnownPrimitive(@NotNull Class<T> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }
}

