/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import me.xemor.sentry.SentryStackTraceFactory;
import me.xemor.sentry.exception.ExceptionMechanismException;
import me.xemor.sentry.protocol.Mechanism;
import me.xemor.sentry.protocol.SentryException;
import me.xemor.sentry.protocol.SentryStackFrame;
import me.xemor.sentry.protocol.SentryStackTrace;
import me.xemor.sentry.protocol.SentryThread;
import me.xemor.sentry.util.Objects;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import me.xemor.superheroes.org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryExceptionFactory {
    @NotNull
    private final SentryStackTraceFactory sentryStackTraceFactory;

    public SentryExceptionFactory(@NotNull SentryStackTraceFactory sentryStackTraceFactory) {
        this.sentryStackTraceFactory = Objects.requireNonNull(sentryStackTraceFactory, "The SentryStackTraceFactory is required.");
    }

    @NotNull
    public List<SentryException> getSentryExceptionsFromThread(@NotNull SentryThread thread, @NotNull Mechanism mechanism, @NotNull Throwable throwable) {
        SentryStackTrace threadStacktrace = thread.getStacktrace();
        if (threadStacktrace == null) {
            return new ArrayList<SentryException>(0);
        }
        ArrayList<SentryException> exceptions = new ArrayList<SentryException>(1);
        exceptions.add(this.getSentryException(throwable, mechanism, thread.getId(), threadStacktrace.getFrames(), true));
        return exceptions;
    }

    @NotNull
    public List<SentryException> getSentryExceptions(@NotNull Throwable throwable) {
        return this.getSentryExceptions(this.extractExceptionQueue(throwable));
    }

    @NotNull
    private List<SentryException> getSentryExceptions(@NotNull Deque<SentryException> exceptions) {
        return new ArrayList<SentryException>(exceptions);
    }

    @NotNull
    private SentryException getSentryException(@NotNull Throwable throwable, @Nullable Mechanism exceptionMechanism, @Nullable Long threadId, @Nullable List<SentryStackFrame> frames, boolean snapshot) {
        String exceptionPackageName;
        Package exceptionPackage = throwable.getClass().getPackage();
        String fullClassName = throwable.getClass().getName();
        SentryException exception = new SentryException();
        String exceptionMessage = throwable.getMessage();
        String exceptionClassName = exceptionPackage != null ? fullClassName.replace(exceptionPackage.getName() + ".", "") : fullClassName;
        String string = exceptionPackageName = exceptionPackage != null ? exceptionPackage.getName() : null;
        if (frames != null && !frames.isEmpty()) {
            SentryStackTrace sentryStackTrace = new SentryStackTrace(frames);
            if (snapshot) {
                sentryStackTrace.setSnapshot(true);
            }
            exception.setStacktrace(sentryStackTrace);
        }
        exception.setThreadId(threadId);
        exception.setType(exceptionClassName);
        exception.setMechanism(exceptionMechanism);
        exception.setModule(exceptionPackageName);
        exception.setValue(exceptionMessage);
        return exception;
    }

    @TestOnly
    @NotNull
    Deque<SentryException> extractExceptionQueue(@NotNull Throwable throwable) {
        ArrayDeque<SentryException> exceptions = new ArrayDeque<SentryException>();
        HashSet<Throwable> circularityDetector = new HashSet<Throwable>();
        for (Throwable currentThrowable = throwable; currentThrowable != null && circularityDetector.add(currentThrowable); currentThrowable = currentThrowable.getCause()) {
            Thread thread;
            Mechanism exceptionMechanism;
            boolean snapshot = false;
            if (currentThrowable instanceof ExceptionMechanismException) {
                ExceptionMechanismException exceptionMechanismThrowable = (ExceptionMechanismException)currentThrowable;
                exceptionMechanism = exceptionMechanismThrowable.getExceptionMechanism();
                currentThrowable = exceptionMechanismThrowable.getThrowable();
                thread = exceptionMechanismThrowable.getThread();
                snapshot = exceptionMechanismThrowable.isSnapshot();
            } else {
                exceptionMechanism = null;
                thread = Thread.currentThread();
            }
            List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames(currentThrowable.getStackTrace());
            SentryException exception = this.getSentryException(currentThrowable, exceptionMechanism, thread.getId(), frames, snapshot);
            exceptions.addFirst(exception);
        }
        return exceptions;
    }
}

