/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.io.IOException;
import java.util.Locale;
import me.xemor.sentry.ILogger;
import me.xemor.sentry.JsonDeserializer;
import me.xemor.sentry.JsonObjectReader;
import me.xemor.sentry.JsonSerializable;
import me.xemor.sentry.ObjectWriter;
import me.xemor.sentry.SentryEvent;
import me.xemor.sentry.Session;
import me.xemor.sentry.clientreport.ClientReport;
import me.xemor.sentry.protocol.SentryTransaction;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum SentryItemType implements JsonSerializable
{
    Session("session"),
    Event("event"),
    UserFeedback("user_report"),
    Attachment("attachment"),
    Transaction("transaction"),
    Profile("profile"),
    ClientReport("client_report"),
    ReplayEvent("replay_event"),
    ReplayRecording("replay_recording"),
    Unknown("__unknown__");

    private final String itemType;

    public static SentryItemType resolve(Object item) {
        if (item instanceof SentryEvent) {
            return Event;
        }
        if (item instanceof SentryTransaction) {
            return Transaction;
        }
        if (item instanceof Session) {
            return Session;
        }
        if (item instanceof ClientReport) {
            return ClientReport;
        }
        return Attachment;
    }

    private SentryItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemType() {
        return this.itemType;
    }

    @NotNull
    public static SentryItemType valueOfLabel(String itemType) {
        for (SentryItemType sentryItemType : SentryItemType.values()) {
            if (!sentryItemType.itemType.equals(itemType)) continue;
            return sentryItemType;
        }
        return Unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.value(this.itemType);
    }

    static final class Deserializer
    implements JsonDeserializer<SentryItemType> {
        Deserializer() {
        }

        @Override
        @NotNull
        public SentryItemType deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            return SentryItemType.valueOfLabel(reader.nextString().toLowerCase(Locale.ROOT));
        }
    }
}

