/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.xemor.sentry.SentryOptions;
import me.xemor.sentry.protocol.SentryStackFrame;
import me.xemor.sentry.util.CollectionUtils;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryStackTraceFactory {
    @NotNull
    private final SentryOptions options;

    public SentryStackTraceFactory(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Nullable
    public List<SentryStackFrame> getStackFrames(@Nullable StackTraceElement[] elements) {
        ArrayList<SentryStackFrame> sentryStackFrames = null;
        if (elements != null && elements.length > 0) {
            sentryStackFrames = new ArrayList<SentryStackFrame>();
            for (StackTraceElement item : elements) {
                String className;
                if (item == null || (className = item.getClassName()).startsWith("me.xemor.sentry.") && !className.startsWith("me.xemor.sentry.samples.") && !className.startsWith("me.xemor.sentry.mobile.")) continue;
                SentryStackFrame sentryStackFrame = new SentryStackFrame();
                sentryStackFrame.setInApp(this.isInApp(className));
                sentryStackFrame.setModule(className);
                sentryStackFrame.setFunction(item.getMethodName());
                sentryStackFrame.setFilename(item.getFileName());
                if (item.getLineNumber() >= 0) {
                    sentryStackFrame.setLineno(item.getLineNumber());
                }
                sentryStackFrame.setNative(item.isNativeMethod());
                sentryStackFrames.add(sentryStackFrame);
            }
            Collections.reverse(sentryStackFrames);
        }
        return sentryStackFrames;
    }

    @Nullable
    public Boolean isInApp(@Nullable String className) {
        if (className == null || className.isEmpty()) {
            return true;
        }
        List<String> inAppIncludes = this.options.getInAppIncludes();
        for (String include : inAppIncludes) {
            if (!className.startsWith(include)) continue;
            return true;
        }
        List<String> inAppExcludes = this.options.getInAppExcludes();
        for (String exclude : inAppExcludes) {
            if (!className.startsWith(exclude)) continue;
            return false;
        }
        return null;
    }

    @NotNull
    List<SentryStackFrame> getInAppCallStack(@NotNull Throwable exception) {
        StackTraceElement[] stacktrace = exception.getStackTrace();
        List<SentryStackFrame> frames = this.getStackFrames(stacktrace);
        if (frames == null) {
            return Collections.emptyList();
        }
        List<SentryStackFrame> inAppFrames = CollectionUtils.filterListEntries(frames, frame -> Boolean.TRUE.equals(frame.isInApp()));
        if (!inAppFrames.isEmpty()) {
            return inAppFrames;
        }
        return CollectionUtils.filterListEntries(frames, frame -> {
            String module = frame.getModule();
            boolean isSystemFrame = false;
            if (module != null) {
                isSystemFrame = module.startsWith("sun.") || module.startsWith("java.") || module.startsWith("android.") || module.startsWith("com.android.");
            }
            return !isSystemFrame;
        });
    }

    @ApiStatus.Internal
    @NotNull
    public List<SentryStackFrame> getInAppCallStack() {
        return this.getInAppCallStack(new Exception());
    }
}

