/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry.internal.debugmeta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import me.xemor.sentry.ILogger;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.internal.debugmeta.IDebugMetaLoader;
import me.xemor.sentry.util.ClassLoaderUtils;
import me.xemor.sentry.util.DebugMetaPropertiesApplier;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ResourcesDebugMetaLoader
implements IDebugMetaLoader {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final ClassLoader classLoader;

    public ResourcesDebugMetaLoader(@NotNull ILogger logger) {
        this(logger, ResourcesDebugMetaLoader.class.getClassLoader());
    }

    ResourcesDebugMetaLoader(@NotNull ILogger logger, @Nullable ClassLoader classLoader) {
        this.logger = logger;
        this.classLoader = ClassLoaderUtils.classLoaderOrDefault(classLoader);
    }

    @Override
    @Nullable
    public Properties loadDebugMeta() {
        block10: {
            InputStream debugMetaStream = this.classLoader.getResourceAsStream(DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            if (debugMetaStream == null) {
                this.logger.log(SentryLevel.INFO, "%s file was not found.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            } else {
                Properties properties;
                BufferedInputStream is = new BufferedInputStream(debugMetaStream);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(is);
                    properties = properties2;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.log(SentryLevel.ERROR, e, "Failed to load %s", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                        break block10;
                    }
                    catch (RuntimeException e) {
                        this.logger.log(SentryLevel.ERROR, e, "%s file is malformed.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                    }
                }
                ((InputStream)is).close();
                return properties;
            }
        }
        return null;
    }
}

