/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry.internal.modules;

import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import me.xemor.sentry.ILogger;
import me.xemor.sentry.SentryLevel;
import me.xemor.sentry.internal.modules.ModulesLoader;
import me.xemor.sentry.util.ClassLoaderUtils;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ResourcesModulesLoader
extends ModulesLoader {
    @NotNull
    private final ClassLoader classLoader;

    public ResourcesModulesLoader(@NotNull ILogger logger) {
        this(logger, ResourcesModulesLoader.class.getClassLoader());
    }

    ResourcesModulesLoader(@NotNull ILogger logger, @Nullable ClassLoader classLoader) {
        super(logger);
        this.classLoader = ClassLoaderUtils.classLoaderOrDefault(classLoader);
    }

    @Override
    protected Map<String, String> loadModules() {
        TreeMap<String, String> modules = new TreeMap<String, String>();
        try {
            InputStream resourcesStream = this.classLoader.getResourceAsStream("sentry-external-modules.txt");
            if (resourcesStream == null) {
                this.logger.log(SentryLevel.INFO, "%s file was not found.", "sentry-external-modules.txt");
                return modules;
            }
            return this.parseStream(resourcesStream);
        }
        catch (SecurityException e) {
            this.logger.log(SentryLevel.INFO, "Access to resources denied.", e);
            return modules;
        }
    }
}

