/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.sentry.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import me.xemor.superheroes.org.jetbrains.annotations.ApiStatus;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileUtils {
    public static boolean deleteRecursively(@Nullable File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        File[] children = file.listFiles();
        if (children == null) {
            return true;
        }
        for (File f : children) {
            if (FileUtils.deleteRecursively(f)) continue;
            return false;
        }
        return file.delete();
    }

    @Nullable
    public static String readText(@Nullable File file) throws IOException {
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            return null;
        }
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = br.readLine();
            if (line != null) {
                contentBuilder.append(line);
            }
            while ((line = br.readLine()) != null) {
                contentBuilder.append("\n").append(line);
            }
        }
        return contentBuilder.toString();
    }
}

