/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.xemor.superheroes.org.apache.commons.lang3.math.NumberUtils;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import me.xemor.superheroes.org.jetbrains.annotations.Nullable;
import org.bukkit.plugin.java.JavaPlugin;

public final class UpdateChecker {
    public static final VersionScheme VERSION_SCHEME_DECIMAL = (first, second) -> {
        String[] firstSplit = UpdateChecker.splitVersionInfo(first);
        String[] secondSplit = UpdateChecker.splitVersionInfo(second);
        if (firstSplit == null || secondSplit == null) {
            return null;
        }
        for (int i = 0; i < Math.min(firstSplit.length, secondSplit.length); ++i) {
            int currentValue = NumberUtils.toInt(firstSplit[i]);
            int newestValue = NumberUtils.toInt(secondSplit[i]);
            if (newestValue > currentValue) {
                return second;
            }
            if (newestValue >= currentValue) continue;
            return first;
        }
        return secondSplit.length > firstSplit.length ? second : first;
    };
    private static final String USER_AGENT = "CHOCO-update-checker";
    private static final String UPDATE_URL = "https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=%d";
    private static final Pattern DECIMAL_SCHEME_PATTERN = Pattern.compile("\\d+(?:\\.\\d+)*");
    private static UpdateChecker instance;
    private UpdateResult lastResult = null;
    private final JavaPlugin plugin;
    private final int pluginID;
    private final VersionScheme versionScheme;

    private UpdateChecker(@NotNull JavaPlugin plugin, int pluginID, @NotNull VersionScheme versionScheme) {
        this.plugin = plugin;
        this.pluginID = pluginID;
        this.versionScheme = versionScheme;
    }

    @NotNull
    public @NotNull CompletableFuture<@NotNull UpdateResult> requestUpdateCheck() {
        return CompletableFuture.supplyAsync(() -> {
            int responseCode;
            try {
                URL url = new URL(String.format(UPDATE_URL, this.pluginID));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.addRequestProperty("User-Agent", USER_AGENT);
                responseCode = connection.getResponseCode();
                JsonParser parser = new JsonParser();
                JsonReader reader = new JsonReader(new InputStreamReader(connection.getInputStream()));
                JsonElement json = parser.parse(reader);
                reader.close();
                if (!json.isJsonObject()) {
                    return new UpdateResult(UpdateReason.INVALID_JSON);
                }
                String currentVersion = json.getAsJsonObject().get("current_version").getAsString();
                String pluginVersion = this.plugin.getDescription().getVersion();
                String latest = this.versionScheme.compareVersions(pluginVersion, currentVersion);
                if (latest == null) {
                    return new UpdateResult(UpdateReason.UNSUPPORTED_VERSION_SCHEME);
                }
                if (latest.equals(pluginVersion)) {
                    return new UpdateResult(pluginVersion.equals(currentVersion) ? UpdateReason.UP_TO_DATE : UpdateReason.UNRELEASED_VERSION);
                }
                if (latest.equals(currentVersion)) {
                    return new UpdateResult(UpdateReason.NEW_UPDATE, latest);
                }
            }
            catch (IOException e) {
                return new UpdateResult(UpdateReason.COULD_NOT_CONNECT);
            }
            return new UpdateResult(responseCode == 401 ? UpdateReason.UNAUTHORIZED_QUERY : UpdateReason.UNKNOWN_ERROR);
        });
    }

    @Nullable
    public UpdateResult getLastResult() {
        return this.lastResult;
    }

    private static String[] splitVersionInfo(String version) {
        Matcher matcher = DECIMAL_SCHEME_PATTERN.matcher(version);
        return matcher.find() ? matcher.group().split("\\.") : null;
    }

    @NotNull
    public static UpdateChecker init(@NotNull JavaPlugin plugin, int pluginID, @NotNull VersionScheme versionScheme) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((pluginID > 0 ? 1 : 0) != 0, (Object)"Plugin ID must be greater than 0");
        Preconditions.checkArgument((versionScheme != null ? 1 : 0) != 0, (Object)"null version schemes are unsupported");
        return instance == null ? (instance = new UpdateChecker(plugin, pluginID, versionScheme)) : instance;
    }

    public static void init(@NotNull JavaPlugin plugin, int pluginID) {
        UpdateChecker.init(plugin, pluginID, VERSION_SCHEME_DECIMAL);
    }

    @NotNull
    public static UpdateChecker get() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance has not yet been initialized. Be sure #init() has been invoked");
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public final class UpdateResult {
        private final UpdateReason reason;
        private final String newestVersion;

        private UpdateResult(@NotNull UpdateReason reason, String newestVersion) {
            UpdateChecker.this.lastResult = this;
            this.reason = reason;
            this.newestVersion = newestVersion;
        }

        private UpdateResult(UpdateReason reason) {
            UpdateChecker.this.lastResult = this;
            Preconditions.checkArgument((reason != UpdateReason.NEW_UPDATE ? 1 : 0) != 0, (Object)"Reasons that require updates must also provide the latest version String");
            this.reason = reason;
            this.newestVersion = UpdateChecker.this.plugin.getDescription().getVersion();
        }

        @NotNull
        public UpdateReason getReason() {
            return this.reason;
        }

        public boolean requiresUpdate() {
            return this.reason == UpdateReason.NEW_UPDATE;
        }

        @NotNull
        public String getNewestVersion() {
            return this.newestVersion;
        }
    }

    @FunctionalInterface
    public static interface VersionScheme {
        @Nullable
        public String compareVersions(@NotNull String var1, @NotNull String var2);
    }

    public static enum UpdateReason {
        NEW_UPDATE,
        COULD_NOT_CONNECT,
        INVALID_JSON,
        UNAUTHORIZED_QUERY,
        UNRELEASED_VERSION,
        UNKNOWN_ERROR,
        UNSUPPORTED_VERSION_SCHEME,
        UP_TO_DATE;

    }
}

