/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes;

import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.UUID;
import me.xemor.superheroes.Superhero;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.events.PlayerChangedSuperheroEvent;
import me.xemor.superheroes.events.SuperheroPlayerJoinEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WorldGuardSupport
implements Listener {
    private static StateFlag allowHeroes;

    public WorldGuardSupport() {
        allowHeroes = (StateFlag)WorldGuard.getInstance().getFlagRegistry().get("allow-heroes");
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        sessionManager.registerHandler((Handler.Factory)WorldGuardHandler.FACTORY, null);
    }

    public static void setupFlag() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            StateFlag flag = new StateFlag("allow-heroes", true);
            registry.register((Flag)flag);
        }
        catch (FlagConflictException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onHeroChange(PlayerChangedSuperheroEvent e) {
        WorldGuardHandler handler;
        if (e.getNewHero() == Superheroes.getInstance().getHeroHandler().getNoPower()) {
            return;
        }
        if (e.getCause() == PlayerChangedSuperheroEvent.Cause.WORLDGUARD) {
            return;
        }
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        Session session = sessionManager.getIfPresent(WorldGuardPlugin.inst().wrapPlayer(e.getPlayer()));
        if (session != null && (handler = (WorldGuardHandler)session.getHandler(WorldGuardHandler.class)) != null && this.getFlag(e.getPlayer(), allowHeroes) == StateFlag.State.DENY) {
            handler.previousHero = e.getNewHero();
            Superheroes.getScheduling().entitySpecificScheduler((Entity)e.getPlayer()).run(() -> Superheroes.getInstance().getHeroHandler().setHeroInMemory(e.getPlayer(), Superheroes.getInstance().getHeroHandler().getNoPower(), false, PlayerChangedSuperheroEvent.Cause.WORLDGUARD), () -> {});
        }
    }

    @EventHandler
    public void onSuperheroLoad(SuperheroPlayerJoinEvent e) {
        WorldGuardHandler handler;
        LocalPlayer localPlayer;
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        Session session = sessionManager.getIfPresent(localPlayer = WorldGuardPlugin.inst().wrapPlayer(e.getPlayer()));
        if (session != null && (handler = (WorldGuardHandler)session.getHandler(WorldGuardHandler.class)) != null) {
            handler.playerCheckHero(localPlayer, this.getFlag(e.getPlayer(), allowHeroes));
        }
    }

    public StateFlag.State getFlag(Player player, StateFlag flag) {
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        Location loc = localPlayer.getLocation();
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(loc);
        return (StateFlag.State)set.queryValue((RegionAssociable)localPlayer, (Flag)flag);
    }

    public static class WorldGuardHandler
    extends FlagValueChangeHandler<StateFlag.State> {
        private Superhero previousHero = null;
        public static final Factory FACTORY = new Factory();

        protected WorldGuardHandler(Session session, Flag<StateFlag.State> flag) {
            super(session, flag);
        }

        public void playerCheckHero(LocalPlayer localPlayer, StateFlag.State state) {
            Player player = Bukkit.getPlayer((UUID)localPlayer.getUniqueId());
            if (player == null) {
                Superheroes.getInstance().getLogger().warning("The player is null in WorldGuardHandler!");
            }
            assert (player != null);
            if (state == StateFlag.State.DENY) {
                this.previousHero = Superheroes.getInstance().getHeroHandler().getSuperhero(player);
                Superheroes.getInstance().getHeroHandler().setHeroInMemory(player, Superheroes.getInstance().getHeroHandler().getNoPower(), false, PlayerChangedSuperheroEvent.Cause.WORLDGUARD);
            } else {
                if (this.previousHero == null) {
                    return;
                }
                Superheroes.getInstance().getHeroHandler().setHeroInMemory(player, this.previousHero, false, PlayerChangedSuperheroEvent.Cause.WORLDGUARD);
            }
        }

        protected void onInitialValue(LocalPlayer localPlayer, ApplicableRegionSet applicableRegionSet, StateFlag.State state) {
        }

        protected boolean onSetValue(LocalPlayer localPlayer, Location location, Location location1, ApplicableRegionSet applicableRegionSet, StateFlag.State state, StateFlag.State t1, MoveType moveType) {
            this.playerCheckHero(localPlayer, state);
            return true;
        }

        protected boolean onAbsentValue(LocalPlayer localPlayer, Location location, Location location1, ApplicableRegionSet applicableRegionSet, StateFlag.State state, MoveType moveType) {
            this.playerCheckHero(localPlayer, state);
            return true;
        }

        public static class Factory
        extends Handler.Factory<WorldGuardHandler> {
            public WorldGuardHandler create(Session session) {
                return new WorldGuardHandler(session, (Flag<StateFlag.State>)allowHeroes);
            }
        }
    }
}

