/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.commands;

import java.util.ArrayList;
import java.util.List;
import me.xemor.superheroes.Superheroes;
import me.xemor.superheroes.commands.SubCommand;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveAttributesCommand
implements SubCommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (sender.hasPermission("superheroes.hero.removeattributes")) {
            String name;
            Player player;
            if (args.length == 1 && sender instanceof Player) {
                Player player2 = (Player)sender;
                this.removeAttributes(player2);
            }
            if (args.length == 2 && (player = Bukkit.getPlayer((String)(name = args[1]))) != null) {
                this.removeAttributes(player);
            }
        }
    }

    public void removeAttributes(Player player) {
        for (Attribute attribute : Attribute.values()) {
            AttributeInstance attributeInstance = player.getAttribute(attribute);
            if (attributeInstance == null) continue;
            ArrayList modifiers = new ArrayList();
            attributeInstance.getModifiers().forEach(am -> {
                String namespace = am.getKey().getNamespace();
                if (namespace.equalsIgnoreCase(Superheroes.getInstance().getName())) {
                    modifiers.add(am);
                } else if (am.getKey().getNamespace().equalsIgnoreCase("minecraft") && am.getKey().getKey().matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")) {
                    modifiers.add(am);
                }
            });
            for (AttributeModifier modifier : modifiers) {
                attributeInstance.removeModifier(modifier);
            }
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        ArrayList<String> heroesTabComplete = new ArrayList<String>();
        if (args.length == 2) {
            String secondArg = args[1];
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().startsWith(secondArg)) continue;
                heroesTabComplete.add(player.getName());
            }
            return heroesTabComplete;
        }
        return null;
    }
}

