/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import me.xemor.superheroes.kyori.adventure.text.Component;
import me.xemor.superheroes.kyori.adventure.text.minimessage.MiniMessage;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.inventory.meta.BookMeta;

public record BookData(String title, String author, List<String> pages) {
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();

    @JsonCreator
    public BookData(String title, String author, List<String> pages) {
        this.title = title != null ? title : "Xemor is cool";
        this.author = author != null ? author : "";
        this.pages = pages != null ? pages : Collections.emptyList();
    }

    public void applyToBookMeta(BookMeta meta) {
        List<String> serializedPages = this.pages.stream().map(s -> legacySerializer.serialize((Component)MiniMessage.miniMessage().deserialize(s))).toList();
        String serializedTitle = legacySerializer.serialize((Component)MiniMessage.miniMessage().deserialize(this.title));
        meta.setGeneration(BookMeta.Generation.ORIGINAL);
        meta.setAuthor(this.author);
        meta.setPages(serializedPages);
        meta.setTitle(serializedTitle);
    }
}

