/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.comparison;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;

@JsonDeserialize(using=RangeDataDeserializer.class)
public class RangeData {
    private double upperbound = Double.POSITIVE_INFINITY;
    private double lowerbound = Double.NEGATIVE_INFINITY;

    public RangeData() {
    }

    public RangeData(String rangeStr) {
        this.init(rangeStr);
    }

    public RangeData(double number) {
        this.upperbound = number;
        this.lowerbound = number;
    }

    public void init(String rangeStr) {
        if ((rangeStr = rangeStr.stripLeading()) != null) {
            String[] split = rangeStr.split("- ");
            if (split.length == 1) {
                this.lowerbound = Double.parseDouble(rangeStr);
                this.upperbound = Double.parseDouble(rangeStr);
            } else {
                this.lowerbound = Double.parseDouble(split[0]);
                this.upperbound = Double.parseDouble(split[1]);
            }
        }
    }

    public boolean isInRange(double value) {
        return value >= this.lowerbound && value <= this.upperbound;
    }

    public static class RangeDataDeserializer
    extends JsonDeserializer<RangeData> {
        public RangeData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            JsonToken token = p.getCurrentToken();
            if (token.isNumeric()) {
                return new RangeData(p.getDoubleValue());
            }
            return new RangeData(p.getText());
        }
    }
}

