/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.configurationdata.entity.EntityComponentRegistry;
import me.xemor.superheroes.configurationdata.entity.EntityData;
import me.xemor.superheroes.configurationdata.entity.components.EntityComponent;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;

public class EntityDataDeserializer
extends JsonDeserializer<EntityData> {
    public EntityData deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        EntityType type;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.isNull() || node.isMissingNode()) {
            return new EntityData();
        }
        NamespacedKey key = NamespacedKey.fromString((String)node.path("type").asText("ZOMBIE").toLowerCase());
        EntityType entityType2 = type = key == null ? EntityType.ZOMBIE : (EntityType)Registry.ENTITY_TYPE.get(key);
        if (type == null) {
            ConfigurationData.getLogger().severe("No entity type found. Possible are: %s".formatted(Registry.ENTITY_TYPE.stream().map(entityType -> entityType.getKey().getKey()).reduce((s1, s2) -> s1 + "," + s2).orElse("")));
        }
        EntityData builder = new EntityData().setType(type).setNameTag(node.path("nameTag").asText()).shouldDespawn(node.path("shouldDespawn").asBoolean(true)).setCustomNameVisible(node.path("customNameVisible").asBoolean(false)).setSilent(node.path("silent").asBoolean(false)).setVisualFire(node.path("visualFire").asBoolean(false));
        if (node.has("attributes")) {
            builder.setAttributes((Map)parser.getCodec().readValue(node.path("attributes").traverse(parser.getCodec()), (TypeReference)new TypeReference<Map<Attribute, Double>>(this){}));
        }
        if (node.has("passenger")) {
            builder.setPassenger((EntityData)context.readValue(node.path("passenger").traverse(parser.getCodec()), EntityData.class));
        }
        List<? extends Class<? extends EntityComponent>> relevantComponentClasses = EntityComponentRegistry.getEntityComponentDataClasses(type.getEntityClass());
        Stream<EntityComponent> components = relevantComponentClasses.stream().map(entityComponentDataClazz -> {
            try {
                return (EntityComponent)context.readTreeAsValue(node, entityComponentDataClazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (node.get("extra") != null) {
            ConfigurationData.getLogger().warning("Please move away from using the extra section within entities");
            Stream<EntityComponent> extraComponents = relevantComponentClasses.stream().map(entityComponentDataClazz -> {
                try {
                    return (EntityComponent)context.readTreeAsValue(node.path("extra"), entityComponentDataClazz);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            components = Stream.concat(components, extraComponents);
        }
        builder.setEntitySpecificAttributes(components.toList());
        return builder;
    }
}

