/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.deserializers.text;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;
import me.xemor.superheroes.configurationdata.deserializers.text.TextDeserializer;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;

public class RegistryDeserializer<T extends Keyed>
extends TextDeserializer<T> {
    private final Registry<T> registry;

    public RegistryDeserializer(Registry<T> registry) {
        this.registry = registry;
    }

    @Override
    public T deserialize(String text, JsonParser parser, DeserializationContext deserializationContext) {
        if (text == null) {
            return null;
        }
        Keyed value = Optional.ofNullable(NamespacedKey.fromString((String)text.toLowerCase())).map(arg_0 -> this.registry.get(arg_0)).orElse(null);
        if (value == null) {
            String fieldName = null;
            try {
                fieldName = parser.getCurrentName();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String location = parser.getTokenLocation().toString();
            String validOptions = this.registry.stream().map(Object::toString).collect(Collectors.joining(", "));
            String errorMessage = String.format("Invalid value '%s' for field '%s' at %s. Expected one of: [%s]", text, fieldName, location, validOptions);
            throw new RuntimeException((Throwable)JsonMappingException.from((JsonParser)parser, (String)errorMessage));
        }
        return (T)value;
    }
}

