/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.entity;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.xemor.superheroes.configurationdata.deserializers.EntityDataDeserializer;
import me.xemor.superheroes.configurationdata.entity.components.EntityComponent;
import me.xemor.superheroes.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import me.xemor.superheroes.org.jetbrains.annotations.NotNull;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

@JsonDeserialize(using=EntityDataDeserializer.class)
public final class EntityData {
    protected static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    private EntityType type = EntityType.ZOMBIE;
    private boolean shouldDespawn = true;
    private String nameTag;
    private boolean customNameVisible = false;
    private boolean silent = false;
    private boolean visualFire = false;
    private Map<Attribute, Double> attributes = null;
    private EntityData passenger = null;
    private List<EntityComponent> entitySpecificAttributes = new ArrayList<EntityComponent>();

    public EntityData setNameTag(String nameTag) {
        this.nameTag = nameTag;
        return this;
    }

    public EntityData setType(EntityType type) {
        this.type = type;
        return this;
    }

    public EntityData shouldDespawn(boolean shouldDespawn) {
        this.shouldDespawn = shouldDespawn;
        return this;
    }

    public EntityData setCustomNameVisible(boolean customNameVisible) {
        this.customNameVisible = customNameVisible;
        return this;
    }

    public EntityData setSilent(boolean silent) {
        this.silent = silent;
        return this;
    }

    public EntityData setVisualFire(boolean visualFire) {
        this.visualFire = visualFire;
        return this;
    }

    public EntityData setAttributes(Map<Attribute, Double> attributes) {
        this.attributes = attributes;
        return this;
    }

    public EntityData setPassenger(EntityData passenger) {
        this.passenger = passenger;
        return this;
    }

    public EntityData setEntitySpecificAttributes(List<EntityComponent> entitySpecificAttributes) {
        this.entitySpecificAttributes = entitySpecificAttributes;
        return this;
    }

    public EntityData getPassenger() {
        return this.passenger;
    }

    public Map<Attribute, Double> getAttributes() {
        return this.attributes;
    }

    public boolean isVisualFire() {
        return this.visualFire;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public String getNameTag() {
        return this.nameTag;
    }

    public boolean shouldDespawn() {
        return this.shouldDespawn;
    }

    public EntityType getType() {
        return this.type;
    }

    public Entity spawnEntity(@NotNull Location location) {
        Entity entity = location.getWorld().spawnEntity(location, this.type);
        this.applyExtraMetadata(entity);
        this.entitySpecificAttributes.forEach(attributeData -> attributeData.apply(entity, this));
        return entity;
    }

    public void applyExtraMetadata(Entity entity) {
        if (this.nameTag != null) {
            entity.setCustomName(this.nameTag);
        }
        entity.setCustomNameVisible(this.customNameVisible);
        entity.setPersistent(!this.shouldDespawn);
        entity.setSilent(this.silent);
        entity.setVisualFire(this.visualFire);
        if (this.passenger != null) {
            Entity spawnedPassenger = this.passenger.spawnEntity(entity.getLocation());
            entity.addPassenger(spawnedPassenger);
        }
    }
}

