/*
 * Decompiled with CFR 0.152.
 */
package me.xemor.superheroes.configurationdata.particles;

import com.fasterxml.jackson.annotation.JsonAlias;
import java.util.List;
import java.util.Optional;
import me.xemor.superheroes.configurationdata.ConfigurationData;
import me.xemor.superheroes.configurationdata.JsonPropertyWithDefault;
import me.xemor.superheroes.configurationdata.particles.EntityShape;
import me.xemor.superheroes.configurationdata.particles.LocationShape;
import me.xemor.superheroes.configurationdata.particles.OptionsData;
import me.xemor.superheroes.configurationdata.particles.shapes.Point;
import me.xemor.superheroes.configurationdata.particles.shapes.Shape;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;

public class ParticleData {
    @JsonPropertyWithDefault
    private double duration = 2.5;
    @JsonPropertyWithDefault
    private Particle particle = Particle.PORTAL;
    @JsonPropertyWithDefault
    @JsonAlias(value={"numberOfParticles"})
    private int amount = 1;
    @JsonPropertyWithDefault
    private Shape shape = new Point();
    @JsonPropertyWithDefault
    private double extra = 0.0;
    @JsonPropertyWithDefault
    private OptionsData options = null;

    private Optional<Color> getColourForTick() {
        if (this.options == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.options.getColours().get(ConfigurationData.getArbitraryClock() % this.options.getColours().size()));
    }

    public void spawnParticle(LivingEntity entity) {
        Shape shape = this.shape;
        if (shape instanceof EntityShape) {
            EntityShape entityShape = (EntityShape)((Object)shape);
            List<Location> particleLocations = entityShape.getWireframe(entity);
            for (Location location : particleLocations) {
                Optional<Particle.DustOptions> dustOptions = this.getColourForTick().map(colour -> new Particle.DustOptions(colour, this.options.getScale()));
                entity.getWorld().spawnParticle(this.particle, location, this.amount, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions.orElse(null));
            }
        }
    }

    public void spawnParticle(Location location) {
        Shape shape = this.shape;
        if (shape instanceof LocationShape) {
            LocationShape locationShape = (LocationShape)((Object)shape);
            List<Location> particleLocations = locationShape.getWireframe(location);
            for (Location particleLocation : particleLocations) {
                Optional<Particle.DustOptions> dustOptions = this.getColourForTick().map(colour -> new Particle.DustOptions(colour, this.options.getScale()));
                location.getWorld().spawnParticle(this.particle, particleLocation, this.amount, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions.orElse(null));
            }
        }
    }

    public int getDuration() {
        return (int)this.duration * 20;
    }

    public Particle getParticle() {
        return this.particle;
    }
}

